package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.utils.TreeUtil;
import com.ejianc.business.cost.vo.ProjectSubjectVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.vo.CostDetailVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 数据明细表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("costDetail")
public class CostDetailController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ICostDetailService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostDetailVO> saveOrUpdate(@RequestBody CostDetailVO saveorUpdateVO) {
    	CostDetailEntity entity = BeanMapper.map(saveorUpdateVO, CostDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	CostDetailVO vo = BeanMapper.map(entity, CostDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostDetailVO> queryDetail(Long id) {
    	CostDetailEntity entity = service.selectById(id);
    	CostDetailVO vo = BeanMapper.map(entity, CostDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostDetailVO> vos) {
        service.removeByIds(vos.stream().map(CostDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<CostDetailEntity> page = service.queryPage(param,false);
        IPage<CostDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostDetailVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/projectSubjectTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectSubjectTree(@RequestParam(value = "projectId") Long projectId,
                                                         @RequestParam(value = "happenDate") String happenDate) {
        List<Map<String, Object>> list = service.projectSubjectTree(projectId,happenDate);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", list);
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }
    /**
     * 导出
     *
     * @return
     */
    @PostMapping("projectSubjectTreeExport")
    public void projectSubjectTreeExport(@RequestBody ProjectSubjectVO vo,
                                         HttpServletResponse response) {
        List<Map<String, Object>> list =new ArrayList<>();
        if(vo != null && vo.getProjectId() > 0 && StringUtils.isNotBlank(vo.getHappenDate())){
            list = service.projectSubjectTree(vo.getProjectId(),vo.getHappenDate());
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", TreeUtil.treeToList(list));
        ExcelExport.getInstance().export("projectSubjectTreeExport-export.xlsx", beans, response);
    }
}
