package com.ejianc.business.cost.mapper;

import com.ejianc.business.cost.bean.CostClosingLastEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.cost.bean.CostFinCostSummaryReportingEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 最终成本关门上报汇总
 *
 * @author generator
 *
 */
@Mapper
public interface CostFinCostSummaryReportingMapper extends BaseCrudMapper<CostFinCostSummaryReportingEntity> {

    @Select("select count(id) from ejc_cost_closing_last where dr = '0' and bill_state IN (1, 3) and project_id = #{projectId}")
    Integer countClosing(@Param("projectId") Long projectId);

    CostClosingLastEntity queryAccumulateProfitMargin(@Param("projectId") Long projectId);


    @Select("select * from ejc_cost_fin_cost_summary_reporting where dr = '0' and project_id = #{projectId}")
    CostFinCostSummaryReportingEntity queryByProject(Long trueprojectId);

    Integer querytotal(@Param("projectId") Long projectId, @Param("id") Long id);

    @Select("select count(id) from ejc_cost_closing_last_change where dr = '0' and bill_state NOT IN (1, 3) and project_id = #{projectId}")
    Integer countClosingChange(@Param("projectId") Long projectId);

    CostFinCostSummaryReportingEntity querySubContractByProjectId(@Param("projectId") Long projectId);

    CostFinCostSummaryReportingEntity querySubContractByProjectIdMaterial(@Param("projectId") Long projectId);

    CostFinCostSummaryReportingEntity querySubContractByProjectIdMachine(@Param("projectId") Long projectId);

    CostFinCostSummaryReportingEntity querySubContractByProjectIdOther(@Param("projectId") Long projectId);
}
