package com.ejianc.business.cost.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.cost.bean.ForecastOtherDetailChangeEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;

/**
 * 其他预估成本关门变更控制明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface ForecastOtherDetailChangeMapper extends BaseCrudMapper<ForecastOtherDetailChangeEntity> {

    List<ForecastOtherDetailChangeEntity> queryall(@Param("sourceForecastId") String sourceForecastId,@Param("subjectName") String subjectName);

    List<ForecastOtherDetailChangeEntity> queryalldata(@Param("projectId") String projectId,@Param("subjectName") String subjectName);

    BigDecimal conjs (@Param("projectId") Long projectId);

    BigDecimal js (@Param("projectId") Long projectId);

    BigDecimal querycontractmoney(@Param("projectId") Long projectId,@Param("subjectId")  Long subjectId,@Param("contractId")  Long contractId);
    BigDecimal querycontractmoneynotax(@Param("projectId") Long projectId,@Param("subjectId")  Long subjectId,@Param("contractId")  Long contractId);

    BigDecimal querysetmoney(@Param("projectId") Long projectId,@Param("subjectId")  Long subjectId);

    @Select("select count(id) from ejc_cost_closing_forecast where dr = '0' and bill_state IN (1, 3) and project_id = #{projectId}")
    Integer queryforecast(@Param("projectId") String projectId);

    BigDecimal querycontractAmountbc(@Param("projectId") Long projectId,@Param("subjectId")  Long subjectId,@Param("contractId")  Long contractId);

    List<ForecastOtherDetailChangeEntity> queryalldatacc(@Param("projectId") String projectId);
}
