package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.CostClosureControlEntity;
import com.ejianc.business.cost.mapper.CostClosureControlMapper;
import com.ejianc.business.cost.service.ICostClosureControlService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 成本关门控制
 * 
 * @author generator
 * 
 */
@Service("costClosureControlService")
public class CostClosureControlServiceImpl extends BaseServiceImpl<CostClosureControlMapper, CostClosureControlEntity> implements ICostClosureControlService{

    @Autowired
    private CostClosureControlMapper costClosureControlMapper;

    @Override
    public List<Map<String, Object>> allrule() {
        List<Map<String,Object>> alldatareal = new ArrayList<>();
        List<CostClosureControlEntity> allrealproject = costClosureControlMapper.queryall();
        if(allrealproject != null && allrealproject.size()>0){
            for(int s = 0;s<allrealproject.size();s++){
                CostClosureControlEntity ccc = allrealproject.get(s);
                Map<String,Object> matmap = new HashMap<>();
                matmap.put("page", ccc.getPage());
                matmap.put("beforeestimate",ccc.getBeforeestimate());
                matmap.put("unauditestimate", ccc.getUnauditestimate());
                matmap.put("auditmake",ccc.getAuditmake());
                matmap.put("makerule", ccc.getMakerule());
                matmap.put("isallow",ccc.getIsallow());
                matmap.put("unauditisallow", ccc.getUnauditisallow());
                matmap.put("isitallow",ccc.getIsitallow());
                matmap.put("allowrule",ccc.getAllowrule());
                matmap.put("billCode",ccc.getBillCode());
                alldatareal.add(matmap);
            }
        }
        return alldatareal;
    }
}
