package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.CostFinContractDetailEntity;
import com.ejianc.business.cost.vo.CostFinContractDetailVO;
import com.ejianc.business.cost.vo.CostFinOtherDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.CostFinOtherDetailMapper;
import com.ejianc.business.cost.bean.CostFinOtherDetailEntity;
import com.ejianc.business.cost.service.ICostFinOtherDetailService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 最终其他成本汇总
 * 
 * @author generator
 * 
 */
@Service("costFinOtherDetailService")
public class CostFinOtherDetailServiceImpl extends BaseServiceImpl<CostFinOtherDetailMapper, CostFinOtherDetailEntity> implements ICostFinOtherDetailService{

    @Override
    public List<CostFinOtherDetailVO> querySubjectByProjectId(String projectId) {
        List<CostFinOtherDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubjectByProjectId(projectId);
        List<CostFinOtherDetailVO> forecastContractDetailVOS = BeanMapper.mapList(forecastContractDetailEntityList, CostFinOtherDetailVO.class);
        return forecastContractDetailVOS;
    }

    @Override
    public BigDecimal subamount(String projectId) {
        List<CostFinOtherDetailEntity> forecastContractDetailEntityList = this.baseMapper.querySubjectByProjectId(projectId);
        BigDecimal amount = new BigDecimal("0");
        if(forecastContractDetailEntityList != null && forecastContractDetailEntityList.size()>0){
            for(CostFinOtherDetailEntity cn :forecastContractDetailEntityList){
                amount = amount.add(cn.getEstimatedTaxAmount());
            }
        }
        return amount;
    }
}
