/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.ejianc.business.budget.bean.BudgetProjectChangeEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.bean.BudgetProjectHistoryEntity;
import com.ejianc.business.budget.mapper.BudgetProjectChangeMapper;
import com.ejianc.business.budget.mapper.BudgetProjectMapper;
import com.ejianc.business.budget.service.IBudgetProjectChangeService;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeService;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectHistoryService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBudgetProjectChangeService changeService;
    @Autowired
    private IBudgetProjectService contractService;
    @Autowired
    private IBudgetProjectHistoryService historyService;
    @Autowired
    private IBudgetProjectDetailService contractDetailService;
    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;
    @Autowired
    private IBudgetProjectDetailChangeService changeDetailService;
    @Autowired
    private BudgetProjectChangeMapper changeMapper;
    @Autowired
    private BudgetProjectMapper budgetMapper;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)this.changeMapper.selectById(billId));
        BudgetProjectEntity contractEntity = (BudgetProjectEntity)((Object)this.budgetMapper.selectById(entity.getBudgetId()));
        BudgetProjectHistoryEntity historyEntity = (BudgetProjectHistoryEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), BudgetProjectHistoryEntity.class));
        historyEntity.setBudgetId(entity.getBudgetId());
        historyEntity.setId(null);
        this.historyService.saveOrUpdate((Object)historyEntity, false);
        QueryParam deparm = new QueryParam();
        deparm.getParams().put("budgetId", new Parameter("eq", (Object)contractEntity.getId()));
        deparm.getParams().put("changeType", new Parameter("ne", (Object)5));
        deparm.getParams().put("dr", new Parameter("eq", (Object)0));
        List checkList = this.contractDetailService.queryList(deparm, false);
        if (null != checkList && checkList.size() > 0) {
            List historyDetails = BeanMapper.mapList((Iterable)checkList, BudgetProjectDetailHistoryEntity.class);
            for (BudgetProjectDetailHistoryEntity hde : historyDetails) {
                hde.setBudgetHistoryId(historyEntity.getId());
                hde.setBudgetId(entity.getBudgetId());
                hde.setBudgetDetailId(hde.getId());
                hde.setId(null);
            }
            this.historyDetailService.saveOrUpdateBatch(historyDetails, historyDetails.size(), false);
        }
        contractEntity.setBeforeChangeBudgetMny(contractEntity.getBudgetMny());
        contractEntity.setBudgetMny(contractEntity.getChangingBudgetMny());
        contractEntity.setChangingBudgetMny(null);
        contractEntity.setBeforeChangeLaborMny(contractEntity.getLaborMny());
        contractEntity.setLaborMny(contractEntity.getChangingLaborMny());
        contractEntity.setChangingLaborMny(null);
        contractEntity.setBeforeChangeMaterialMny(contractEntity.getMaterialMny());
        contractEntity.setMaterialMny(contractEntity.getChangingMaterialMny());
        contractEntity.setChangingMaterialMny(null);
        contractEntity.setBeforeChangeMechanicalMny(contractEntity.getMechanicalMny());
        contractEntity.setMechanicalMny(contractEntity.getChangingMechanicalMny());
        contractEntity.setChangingMechanicalMny(null);
        contractEntity.setBeforeChangeOtherMny(contractEntity.getOtherMny());
        contractEntity.setOtherMny(contractEntity.getChangingOtherMny());
        contractEntity.setChangingOtherMny(null);
        contractEntity.setChangeStatus(3);
        contractEntity.setChangeCode(contractEntity.getChangeCode());
        contractEntity.setChangeId(contractEntity.getChangeId());
        contractEntity.setBillState(contractEntity.getBillState());
        contractEntity.setProjectId(entity.getProjectId());
        contractEntity.setProjectName(entity.getProjectName());
        contractEntity.setBillCode(entity.getBillCode());
        contractEntity.setChangeReason(entity.getChangeReason());
        contractEntity.setChangeVersion(entity.getChangeVersion());
        HashMap<Long, BudgetProjectDetailEntity> checkMap = new HashMap<Long, BudgetProjectDetailEntity>();
        for (BudgetProjectDetailEntity bd : checkList) {
            checkMap.put(bd.getId(), bd);
        }
        this.contractDetailService.deleteByBudgetId(entity.getBudgetId());
        QueryParam parm = new QueryParam();
        parm.getParams().put("budgetChangeId", new Parameter("eq", (Object)entity.getId()));
        List changeDetailList = this.changeDetailService.queryList(parm, false);
        int leaf = 0;
        int subject = 0;
        if (null != changeDetailList && changeDetailList.size() > 0) {
            ArrayList<BudgetProjectDetailEntity> detailList = new ArrayList<BudgetProjectDetailEntity>();
            for (BudgetProjectDetailChangeEntity cde : changeDetailList) {
                Long detailId = cde.getBudgetDetailId();
                if (cde.getLeafFlag().booleanValue()) {
                    if (checkMap.get(detailId) != null) {
                        cde.setSubjectId(((BudgetProjectDetailEntity)((Object)checkMap.get(detailId))).getSubjectId());
                        cde.setSubjectName(((BudgetProjectDetailEntity)((Object)checkMap.get(detailId))).getSubjectName());
                        if ((null == cde.getChangeType() || cde.getChangeType() != 5) && ((BudgetProjectDetailEntity)((Object)checkMap.get(detailId))).getSubjectId() != null) {
                            ++subject;
                        }
                    } else {
                        cde.setSubjectId(null);
                        cde.setSubjectName(null);
                    }
                    if (null == cde.getChangeType() || cde.getChangeType() != 5) {
                        ++leaf;
                    }
                }
                BudgetProjectDetailEntity cdetail = (BudgetProjectDetailEntity)((Object)BeanMapper.map((Object)((Object)cde), BudgetProjectDetailEntity.class));
                cdetail.setId(null);
                cdetail.setChangeBid(cde.getId());
                if (null == cdetail.getChangeType() || cdetail.getChangeType() != 5) {
                    cdetail.setChangeType(0);
                }
                detailList.add(cdetail);
            }
            this.contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
            HashMap<Long, Long> parentMap = new HashMap<Long, Long>();
            for (BudgetProjectDetailEntity cde : detailList) {
                parentMap.put(cde.getChangeBid(), cde.getId());
            }
            for (BudgetProjectDetailEntity cde : detailList) {
                if (cde.getParentId() == null || cde.getParentId() <= 0L) continue;
                cde.setParentId((Long)parentMap.get(cde.getParentId()));
            }
            this.contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        if (leaf == subject) {
            contractEntity.setLinkedFlag(1);
            contractEntity.setUnassociate(0);
        } else {
            contractEntity.setLinkedFlag(0);
            contractEntity.setUnassociate(leaf - subject);
        }
        this.contractService.saveOrUpdate((Object)contractEntity);
        entity.setUsedTime(new Date());
        this.changeService.saveOrUpdate((Object)entity, false);
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT210302000000002", "budgetProjectChange", String.valueOf(contractEntity.getId()), "BT210302000000001", "budgetProject");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

