/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.ForecastOtherDetailChangeEntity;
import com.ejianc.business.cost.bean.SubjectProjectEntity;
import com.ejianc.business.cost.mapper.ForecastOtherDetailChangeMapper;
import com.ejianc.business.cost.service.IForecastOtherDetailChangeService;
import com.ejianc.business.cost.service.ISubjectProjectService;
import com.ejianc.business.cost.vo.ForecastOtherDetailChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"forecastOtherDetailChange"})
public class ForecastOtherDetailChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IForecastOtherDetailChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ForecastOtherDetailChangeMapper baseMapper;
    @Autowired
    private ISubjectProjectService subjectProjectService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ForecastOtherDetailChangeVO> saveOrUpdate(@RequestBody ForecastOtherDetailChangeVO saveOrUpdateVO) {
        ForecastOtherDetailChangeEntity entity = (ForecastOtherDetailChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ForecastOtherDetailChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ForecastOtherDetailChangeVO vo = (ForecastOtherDetailChangeVO)BeanMapper.map((Object)((Object)entity), ForecastOtherDetailChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ForecastOtherDetailChangeVO> queryDetail(Long id) {
        ForecastOtherDetailChangeEntity entity = (ForecastOtherDetailChangeEntity)((Object)this.service.selectById(id));
        ForecastOtherDetailChangeVO vo = (ForecastOtherDetailChangeVO)BeanMapper.map((Object)((Object)entity), ForecastOtherDetailChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastOtherDetailChangeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ForecastOtherDetailChangeVO forecastOtherDetailChangeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ForecastOtherDetailChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastOtherDetailChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ForecastOtherDetailChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refForecastOtherDetailChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ForecastOtherDetailChangeVO>> refForecastOtherDetailChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastOtherDetailChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryOtherDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> type(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("sourceForecastId");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        String sourceForecastId = null;
        String subjectName = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            sourceForecastId = _con.getString("sourceForecastId");
            subjectName = _con.getString("subjectName");
        }
        List<ForecastOtherDetailChangeEntity> list = this.baseMapper.queryall(sourceForecastId, subjectName);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (list != null && list.size() > 0) {
            for (ForecastOtherDetailChangeEntity entity : list) {
                String isin = "N";
                Long sotid = entity.getSourceForecastOtherId();
                Long nid = entity.getId();
                if (sotid != null && nid != null && sotid != nid && ids != null && ids.size() > 0) {
                    for (Long iddata : ids) {
                        if (!iddata.equals(sotid)) continue;
                        isin = "Y";
                        break;
                    }
                }
                if (!isin.equals("N")) continue;
                map = new HashMap<String, Object>();
                map.put("id", entity.getId());
                map.put("sourceForecastOtherId", entity.getSourceForecastOtherId());
                map.put("sourceForecastId", entity.getSourceForecastId());
                map.put("costTypeId", entity.getCostTypeId());
                map.put("costTypeName", entity.getCostTypeName());
                map.put("costAnalysis", entity.getCostAnalysis());
                map.put("subjectId", entity.getSubjectId());
                map.put("subjectName", entity.getSubjectName());
                map.put("estimatedAmount", entity.getEstimatedAmount());
                map.put("estimatedTaxAmount", entity.getEstimatedTaxAmount());
                map.put("taxMny", entity.getTaxMny());
                ids.add(entity.getId());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/queryAllOtherDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> alltype(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("projectId");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("projectId")) {
                throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u9879\u76ee\uff01");
            }
        } else {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u9879\u76ee\uff01");
        }
        Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        String projectId2 = null;
        String subjectName = null;
        Long contractId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            projectId2 = _con.getString("projectId");
            subjectName = _con.getString("subjectName");
            contractId = _con.getLong("contractId");
        }
        List<ForecastOtherDetailChangeEntity> list = this.baseMapper.queryalldata(projectId2, subjectName);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (list != null && list.size() > 0) {
            for (ForecastOtherDetailChangeEntity entity : list) {
                String isin = "N";
                Long subjectid = entity.getSubjectId();
                if (ids != null && ids.size() > 0) {
                    for (Long iddata : ids) {
                        if (!iddata.equals(subjectid)) continue;
                        isin = "Y";
                        break;
                    }
                }
                if (!isin.equals("N")) continue;
                BigDecimal sourcemoney = entity.getEstimatedTaxAmount();
                BigDecimal htmoney = this.baseMapper.querycontractmoney(entity.getProjectId(), entity.getSubjectId(), contractId);
                BigDecimal contractAmountbc = this.baseMapper.querycontractAmountbc(entity.getProjectId(), entity.getSubjectId(), contractId);
                BigDecimal jsmoney = this.baseMapper.querysetmoney(entity.getProjectId(), entity.getSubjectId());
                BigDecimal money = sourcemoney.subtract(htmoney).subtract(jsmoney).subtract(contractAmountbc);
                map = new HashMap<String, Object>();
                map.put("id", entity.getSubjectId());
                map.put("projectId", entity.getProjectId());
                map.put("costTypeId", entity.getCostTypeId());
                map.put("costTypeName", entity.getCostTypeName());
                map.put("costAnalysis", entity.getCostAnalysis());
                map.put("subjectId", entity.getSubjectId());
                map.put("name", entity.getSubjectName());
                map.put("estimatedAmount", money);
                map.put("estimatedTaxAmount", entity.getEstimatedTaxAmount());
                map.put("taxMny", entity.getTaxMny());
                ids.add(entity.getSubjectId());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/querysubject"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refSubjectProjectData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        ArrayList resultMapList;
        block7: {
            HashMap<String, Object> map;
            Integer count;
            String subjectName;
            String projectId;
            block6: {
                QueryParam param = new QueryParam();
                param.setSearchText(searchText);
                param.getFuzzyFields().add("subjectName");
                param.getFuzzyFields().add("subjectCode");
                param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                param.getOrderMap().put("subjectCode", "asc");
                projectId = null;
                subjectName = null;
                if (StringUtils.isNotEmpty((CharSequence)condition)) {
                    JSONObject _con = JSONObject.parseObject((String)condition);
                    projectId = _con.getString("projectId");
                    subjectName = _con.getString("subjectName");
                }
                projectId = "794566967620026456";
                count = this.baseMapper.queryforecast(projectId);
                resultMapList = new ArrayList();
                map = null;
                if (count != 0) break block6;
                List list = this.subjectProjectService.queryList(param, false);
                for (SubjectProjectEntity entity : list) {
                    map = new HashMap<String, Object>();
                    map.put("id", entity.getId());
                    map.put("key", entity.getId());
                    map.put("name", entity.getSubjectName());
                    map.put("code", entity.getSubjectCode());
                    map.put("parentId", entity.getParentId());
                    map.put("memo", entity.getMemo());
                    map.put("orgSubjectId", entity.getOrgSubjectId());
                    map.put("innerCode", entity.getInnerCode());
                    resultMapList.add(map);
                }
                break block7;
            }
            if (count != 1) break block7;
            List<ForecastOtherDetailChangeEntity> list = this.baseMapper.queryalldata(projectId, subjectName);
            ArrayList<Long> ids = new ArrayList<Long>();
            if (list != null && list.size() > 0) {
                for (ForecastOtherDetailChangeEntity entity : list) {
                    String isin = "N";
                    Long subjectid = entity.getSubjectId();
                    if (ids != null && ids.size() > 0) {
                        for (Long iddata : ids) {
                            if (!iddata.equals(subjectid)) continue;
                            isin = "Y";
                            break;
                        }
                    }
                    if (!isin.equals("N")) continue;
                    BigDecimal sourcemoney = entity.getEstimatedTaxAmount();
                    Long contractId = null;
                    BigDecimal htmoney = this.baseMapper.querycontractmoney(entity.getProjectId(), entity.getSubjectId(), contractId);
                    BigDecimal jsmoney = this.baseMapper.querysetmoney(entity.getProjectId(), entity.getSubjectId());
                    BigDecimal money = sourcemoney.subtract(htmoney).subtract(jsmoney);
                    map = new HashMap();
                    map.put("id", entity.getSubjectId());
                    map.put("projectId", entity.getProjectId());
                    map.put("costTypeId", entity.getCostTypeId());
                    map.put("costTypeName", entity.getCostTypeName());
                    map.put("costAnalysis", entity.getCostAnalysis());
                    map.put("subjectId", entity.getSubjectId());
                    map.put("name", entity.getSubjectName());
                    map.put("estimatedAmount", money);
                    map.put("estimatedTaxAmount", entity.getEstimatedTaxAmount());
                    map.put("taxMny", entity.getTaxMny());
                    ids.add(entity.getSubjectId());
                    resultMapList.add(map);
                }
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}

