/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller.api;

import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.service.ISettingService;
import com.ejianc.business.cost.service.ISubjectService;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cost/"})
public class CostDetailApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService costDetailService;
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;

    @RequestMapping(value={"saveSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostDetailVO> saveSubject(@RequestBody List<CostDetailVO> list) {
        this.logger.info("\u5173\u8054\u4fdd\u5b58\u5f00\u59cb......");
        try {
            if (CollectionUtils.isNotEmpty(list)) {
                List listres = BeanMapper.mapList(list, CostDetailEntity.class);
                this.costDetailService.deleteCostDetail(((CostDetailEntity)((Object)listres.get(0))).getSourceId());
                this.costDetailService.saveBatch(listres);
            }
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u63d2\u5165\u5931\u8d25");
        }
        this.logger.info("\u5173\u8054\u4fdd\u5b58\u7ed3\u675f......");
        return CommonResponse.success((String)"\u63d2\u5165\u6210\u529f");
    }

    @RequestMapping(value={"deleteCostDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostDetailVO> deleteCostDetail(@RequestParam Long id) {
        try {
            this.costDetailService.deleteCostDetail(id);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

