/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.mapper.CostDetailMapper;
import com.ejianc.business.cost.service.ICostDetailService;
import com.ejianc.business.cost.service.ISubjectProjectService;
import com.ejianc.business.cost.utils.DateCompareUtil;
import com.ejianc.business.cost.utils.MathUtil;
import com.ejianc.business.cost.vo.ProjectSubjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costDetailService")
public class CostDetailServiceImpl
extends BaseServiceImpl<CostDetailMapper, CostDetailEntity>
implements ICostDetailService {
    @Autowired
    private ISubjectProjectService subjectProjectService;

    @Override
    public boolean deleteCostDetail(Long id) {
        return ((CostDetailMapper)this.baseMapper).deleteCostDetail(id);
    }

    @Override
    public List<Map<String, Object>> projectSubjectTree(Long projectId, String happenDate) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List list = this.subjectProjectService.queryList(param, false);
        if (list == null || list.size() <= 0) {
            return new ArrayList<Map<String, Object>>();
        }
        List res = BeanMapper.mapList((Iterable)list, ProjectSubjectVO.class);
        List subjectIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(BaseEntity::getDr, (Object)0);
        lambd.in(CostDetailEntity::getSubjectId, subjectIdList);
        List costList = super.list((Wrapper)lambd);
        HashMap<Long, BigDecimal> monthMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> yearMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> allMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> monthTaxMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> yearTaxMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> allTaxMap = new HashMap<Long, BigDecimal>();
        BigDecimal sumAll = BigDecimal.ZERO;
        BigDecimal sumTaxAll = BigDecimal.ZERO;
        for (CostDetailEntity cde : costList) {
            BigDecimal mny;
            BigDecimal happenTaxMny;
            Long subjectId = cde.getSubjectId();
            BigDecimal happenMny = cde.getHappenMny() == null ? BigDecimal.ZERO : cde.getHappenMny();
            BigDecimal bigDecimal = happenTaxMny = cde.getHappenTaxMny() == null ? BigDecimal.ZERO : cde.getHappenTaxMny();
            if (DateCompareUtil.isThisMonth(happenDate, cde.getHappenDate()).booleanValue()) {
                if (monthMap.containsKey(subjectId)) {
                    mny = (BigDecimal)monthMap.get(subjectId);
                    monthMap.put(subjectId, MathUtil.safeAdd(happenMny, mny));
                } else {
                    monthMap.put(subjectId, happenMny);
                }
            }
            if (DateCompareUtil.isThisMonth(happenDate, cde.getHappenDate()).booleanValue()) {
                if (monthTaxMap.containsKey(subjectId)) {
                    mny = (BigDecimal)monthTaxMap.get(subjectId);
                    monthTaxMap.put(subjectId, MathUtil.safeAdd(happenTaxMny, mny));
                } else {
                    monthTaxMap.put(subjectId, happenTaxMny);
                }
            }
            if (DateCompareUtil.isThisYear(happenDate, cde.getHappenDate()).booleanValue()) {
                if (yearMap.containsKey(subjectId)) {
                    mny = (BigDecimal)yearMap.get(subjectId);
                    yearMap.put(subjectId, MathUtil.safeAdd(happenMny, mny));
                } else {
                    yearMap.put(subjectId, happenMny);
                }
            }
            if (DateCompareUtil.isThisYear(happenDate, cde.getHappenDate()).booleanValue()) {
                if (yearTaxMap.containsKey(subjectId)) {
                    mny = (BigDecimal)yearTaxMap.get(subjectId);
                    yearTaxMap.put(subjectId, MathUtil.safeAdd(happenTaxMny, mny));
                } else {
                    yearTaxMap.put(subjectId, happenTaxMny);
                }
            }
            if (allMap.containsKey(subjectId)) {
                mny = (BigDecimal)allMap.get(subjectId);
                allMap.put(subjectId, MathUtil.safeAdd(happenMny, mny));
            } else {
                allMap.put(subjectId, happenMny);
            }
            if (allTaxMap.containsKey(subjectId)) {
                mny = (BigDecimal)allTaxMap.get(subjectId);
                allTaxMap.put(subjectId, MathUtil.safeAdd(happenTaxMny, mny));
            } else {
                allTaxMap.put(subjectId, happenTaxMny);
            }
            sumAll = MathUtil.safeAdd(happenMny, sumAll);
            sumTaxAll = MathUtil.safeAdd(happenTaxMny, sumTaxAll);
        }
        for (ProjectSubjectVO psv : res) {
            psv.setSumMonthSbuject((BigDecimal)monthMap.get(psv.getId()));
            psv.setSumYearSbuject((BigDecimal)yearMap.get(psv.getId()));
            psv.setSumAllSbuject((BigDecimal)allMap.get(psv.getId()));
            psv.setSumMonthTaxSbuject((BigDecimal)monthTaxMap.get(psv.getId()));
            psv.setSumYearTaxSbuject((BigDecimal)yearTaxMap.get(psv.getId()));
            psv.setSumAllTaxSbuject((BigDecimal)allTaxMap.get(psv.getId()));
        }
        List resultMapList = BeanMapper.mapList((Iterable)res, Map.class);
        List subTree = ResultAsTree.createTreeData((List)resultMapList);
        List<Map<String, Object>> automatic = this.automatic(subTree, sumAll, sumTaxAll);
        return automatic;
    }

    private List<Map<String, Object>> automatic(List<Map<String, Object>> list, BigDecimal sumAll, BigDecimal sumTaxAll) {
        for (Map<String, Object> map : list) {
            List child = (List)map.get("children");
            if (child != null) {
                List<Map<String, Object>> newChildren = this.automatic(child, sumAll, sumTaxAll);
                map.put("children", newChildren);
                BigDecimal sumMonthSbuject = (BigDecimal)map.get("sumMonthSbuject");
                BigDecimal newSumMonthSbuject = MathUtil.safeAdd(sumMonthSbuject, this.childSum(newChildren, "sumMonthSbuject"));
                map.put("sumMonthSbuject", newSumMonthSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumMonthSbuject);
                BigDecimal sumMonthTaxSbuject = (BigDecimal)map.get("sumMonthTaxSbuject");
                BigDecimal newSumMonthTaxSbuject = MathUtil.safeAdd(sumMonthTaxSbuject, this.childSum(newChildren, "sumMonthTaxSbuject"));
                map.put("sumMonthTaxSbuject", newSumMonthTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumMonthTaxSbuject);
                BigDecimal sumYearSbuject = (BigDecimal)map.get("sumYearSbuject");
                BigDecimal newSumYearSbuject = MathUtil.safeAdd(sumYearSbuject, this.childSum(newChildren, "sumYearSbuject"));
                map.put("sumYearSbuject", newSumYearSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumYearSbuject);
                BigDecimal sumYearTaxSbuject = (BigDecimal)map.get("sumYearTaxSbuject");
                BigDecimal newSumYearTaxSbuject = MathUtil.safeAdd(sumYearTaxSbuject, this.childSum(newChildren, "sumYearTaxSbuject"));
                map.put("sumYearTaxSbuject", newSumYearTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumYearTaxSbuject);
                BigDecimal sumAllSbuject = (BigDecimal)map.get("sumAllSbuject");
                BigDecimal newSumAllSbuject = MathUtil.safeAdd(sumAllSbuject, this.childSum(newChildren, "sumAllSbuject"));
                map.put("sumAllSbuject", newSumAllSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumAllSbuject);
                BigDecimal sumAllTaxSbuject = (BigDecimal)map.get("sumAllTaxSbuject");
                BigDecimal newSumAllTaxSbuject = MathUtil.safeAdd(sumAllTaxSbuject, this.childSum(newChildren, "sumAllTaxSbuject"));
                map.put("sumAllTaxSbuject", newSumAllTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumAllTaxSbuject);
                BigDecimal subjectRate = MathUtil.safeMultiply(MathUtil.safeDiv(newSumAllSbuject, sumAll), new BigDecimal("100"));
                map.put("subjectRate", subjectRate);
                BigDecimal subjectTaxRate = MathUtil.safeMultiply(MathUtil.safeDiv(newSumAllTaxSbuject, sumTaxAll), new BigDecimal("100"));
                map.put("subjectTaxRate", subjectTaxRate);
                continue;
            }
            BigDecimal sumMonthSbuject = (BigDecimal)map.get("sumMonthSbuject");
            map.put("sumMonthSbuject", sumMonthSbuject == null || sumMonthSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumMonthSbuject);
            BigDecimal sumMonthTaxSbuject = (BigDecimal)map.get("sumMonthTaxSbuject");
            map.put("sumMonthTaxSbuject", sumMonthTaxSbuject == null || sumMonthTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumMonthTaxSbuject);
            BigDecimal sumYearSbuject = (BigDecimal)map.get("sumYearSbuject");
            map.put("sumYearSbuject", sumYearSbuject == null || sumYearSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumYearSbuject);
            BigDecimal sumYearTaxSbuject = (BigDecimal)map.get("sumYearTaxSbuject");
            map.put("sumYearTaxSbuject", sumYearTaxSbuject == null || sumYearTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumYearTaxSbuject);
            BigDecimal sumAllSbuject = (BigDecimal)map.get("sumAllSbuject");
            map.put("sumAllSbuject", sumAllSbuject == null || sumAllSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumAllSbuject);
            BigDecimal sumAllTaxSbuject = (BigDecimal)map.get("sumAllTaxSbuject");
            map.put("sumAllTaxSbuject", sumAllTaxSbuject == null || sumAllTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumAllTaxSbuject);
            BigDecimal subjectRate = MathUtil.safeMultiply(MathUtil.safeDiv(sumAllSbuject, sumAll), new BigDecimal("100"));
            map.put("subjectRate", subjectRate);
            BigDecimal subjectTaxRate = MathUtil.safeMultiply(MathUtil.safeDiv(sumAllTaxSbuject, sumTaxAll), new BigDecimal("100"));
            map.put("subjectTaxRate", subjectTaxRate);
        }
        return list;
    }

    private BigDecimal childSum(List<Map<String, Object>> list, String colums) {
        BigDecimal allMny = BigDecimal.ZERO;
        for (Map<String, Object> map : list) {
            BigDecimal mny = (BigDecimal)map.get(colums);
            allMny = MathUtil.safeAdd(allMny, mny);
        }
        return allMny;
    }
}

