package com.ejianc.business.budget.controller;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.budget.bean.BudgetProjectHistoryEntity;
import com.ejianc.business.budget.service.IBudgetProjectHistoryService;
import com.ejianc.business.budget.vo.BudgetProjectHistoryVO;

/**
 * 项目预算记录表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("budgetProjectHistory")
public class BudgetProjectHistoryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBudgetProjectHistoryService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectHistoryVO> saveOrUpdate(@RequestBody BudgetProjectHistoryVO saveorUpdateVO) {
    	BudgetProjectHistoryEntity entity = BeanMapper.map(saveorUpdateVO, BudgetProjectHistoryEntity.class);
    	service.saveOrUpdate(entity, false);
    	BudgetProjectHistoryVO vo = BeanMapper.map(entity, BudgetProjectHistoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectHistoryVO> queryDetail(Long id) {
    	BudgetProjectHistoryEntity entity = service.selectById(id);
    	BudgetProjectHistoryVO vo = BeanMapper.map(entity, BudgetProjectHistoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectHistoryVO> vos) {
        service.removeByIds(vos.stream().map(BudgetProjectHistoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectHistoryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<BudgetProjectHistoryEntity> page = service.queryPage(param,false);
        IPage<BudgetProjectHistoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectHistoryVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 根据变更主键ID查询历史详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailByChangeId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectHistoryVO> queryDetailByChangeId(@RequestParam Long id) {
        BudgetProjectHistoryVO historyVo = service.queryDetailByChangeId(id);
        return CommonResponse.success(historyVo);
    }

}
