package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.mapper.CostCategoryMapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.CostCategoryEntity;
import com.ejianc.business.cost.service.ICostCategoryService;
import com.ejianc.business.cost.vo.CostCategoryVO;

/**
 * 费用类别
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costCategory")
public class CostCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICostCategoryService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CostCategoryMapper costCategoryMapper;

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/type", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> type(@RequestParam(value = "searchText", required = false) String searchText,
                                                            @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getOrderMap().put("code", "asc");
        List<CostCategoryEntity> list = costCategoryMapper.queryall();
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(CostCategoryEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("code", entity.getCode());
            map.put("name", entity.getName());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}
