package com.ejianc.business.cost.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.vo.report.OrgSubjectReportVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface IReportService extends IBaseService<CostDetailEntity> {

    JSONObject subjectCostList(QueryParam param);

    JSONObject getProductionVersusCostCompanyList(QueryParam param);
    
    JSONObject queryProjectProductionCostTwo(QueryParam param);
    
    JSONObject queryProjectCostThree(QueryParam param);

    List<Map<String,Object>> getProductionVersusCostAccountingTreeList(Long projectId, String happenDate);

    JSONObject accountingCostList(QueryParam param);

    List<OrgSubjectReportVO> querySubjectCostList(Integer yearFlag);

    List<Map<String,Object>> projectCompletionSum(Long projectId);

    List<Map<String, Object>> projectCompletionSumRealtime(Long projectId);

    JSONObject costSummaryList(QueryParam param);

    List<Map<String, Object>> revenueExpenditureSummary();

    List<Map<String, Object>> ExpenditureSummaryRealTime();

    List<Map<String, Object>> lastRevenueExpenditureSummary();

    List<Map<String, Object>> projectFinCompletionSum(Long projectId);

    List<Map<String, Object>> projectFinExhaustedSum(Long projectId);

    List<Map<String, Object>> projectFinClosingSumRealTime(Long projectId);

    List<Map<String, Object>> projectFinAllClosingSumRealTime();

//    List<Map<String,Object>> projectCompletionSumList(Long projectId);

}
