package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.cost.bean.SubjectProjectEntity;
import com.ejianc.business.cost.service.ISubjectProjectService;
import com.ejianc.business.cost.utils.DateCompareUtil;
import com.ejianc.business.cost.utils.MathUtil;
import com.ejianc.business.cost.vo.ProjectSubjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.CostDetailMapper;
import com.ejianc.business.cost.bean.CostDetailEntity;
import com.ejianc.business.cost.service.ICostDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 数据明细表
 *
 * @author generator
 */
@Service("costDetailService")
public class CostDetailServiceImpl extends BaseServiceImpl<CostDetailMapper, CostDetailEntity> implements ICostDetailService {

    @Autowired
    private ISubjectProjectService subjectProjectService;

    @Override
    public boolean deleteCostDetail(Long id) {
        return baseMapper.deleteCostDetail(id);
    }

    @Override
    public List<Map<String, Object>> projectSubjectTree(Long projectId, String happenDate) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectProjectEntity> list = subjectProjectService.queryList(param, false);
        if (list == null || list.size() <= 0) {
            return new ArrayList<>();
        }
        List<ProjectSubjectVO> res = BeanMapper.mapList(list, ProjectSubjectVO.class);
        List<Long> subjectIdList = list.stream().map(SubjectProjectEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<CostDetailEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(CostDetailEntity::getDr, 0);
        lambd.in(CostDetailEntity::getSubjectId, subjectIdList);
        List<CostDetailEntity> costList = super.list(lambd);
        Map<Long, BigDecimal> monthMap = new HashMap<>();
        Map<Long, BigDecimal> yearMap = new HashMap<>();
        Map<Long, BigDecimal> allMap = new HashMap<>();
        Map<Long, BigDecimal> monthTaxMap = new HashMap<>();
        Map<Long, BigDecimal> yearTaxMap = new HashMap<>();
        Map<Long, BigDecimal> allTaxMap = new HashMap<>();
        BigDecimal sumAll = BigDecimal.ZERO;
        BigDecimal sumTaxAll = BigDecimal.ZERO;
        for (CostDetailEntity cde : costList) {
            Long subjectId = cde.getSubjectId();
            BigDecimal happenMny = cde.getHappenMny() == null ? BigDecimal.ZERO : cde.getHappenMny();
            BigDecimal happenTaxMny = cde.getHappenTaxMny() == null ? BigDecimal.ZERO : cde.getHappenTaxMny();
            if (DateCompareUtil.isThisMonth(happenDate, cde.getHappenDate())) {
                if (monthMap.containsKey(subjectId)) {
                    BigDecimal mny = monthMap.get(subjectId);
                    monthMap.put(subjectId, MathUtil.safeAdd(happenMny, mny));
                } else {
                    monthMap.put(subjectId, happenMny);
                }
            }
            if (DateCompareUtil.isThisMonth(happenDate, cde.getHappenDate())) {
                if (monthTaxMap.containsKey(subjectId)) {
                    BigDecimal mny = monthTaxMap.get(subjectId);
                    monthTaxMap.put(subjectId, MathUtil.safeAdd(happenTaxMny, mny));
                } else {
                    monthTaxMap.put(subjectId, happenTaxMny);
                }
            }
            if (DateCompareUtil.isThisYear(happenDate, cde.getHappenDate())) {
                if (yearMap.containsKey(subjectId)) {
                    BigDecimal mny = yearMap.get(subjectId);
                    yearMap.put(subjectId, MathUtil.safeAdd(happenMny, mny));
                } else {
                    yearMap.put(subjectId, happenMny);
                }
            }
            if (DateCompareUtil.isThisYear(happenDate, cde.getHappenDate())) {
                if (yearTaxMap.containsKey(subjectId)) {
                    BigDecimal mny = yearTaxMap.get(subjectId);
                    yearTaxMap.put(subjectId, MathUtil.safeAdd(happenTaxMny, mny));
                } else {
                    yearTaxMap.put(subjectId, happenTaxMny);
                }
            }
            if (allMap.containsKey(subjectId)) {
                BigDecimal mny = allMap.get(subjectId);
                allMap.put(subjectId, MathUtil.safeAdd(happenMny, mny));
            } else {
                allMap.put(subjectId, happenMny);
            }
            if (allTaxMap.containsKey(subjectId)) {
                BigDecimal mny = allTaxMap.get(subjectId);
                allTaxMap.put(subjectId, MathUtil.safeAdd(happenTaxMny, mny));
            } else {
                allTaxMap.put(subjectId, happenTaxMny);
            }
            sumAll = MathUtil.safeAdd(happenMny, sumAll);
            sumTaxAll = MathUtil.safeAdd(happenTaxMny, sumTaxAll);
        }
        for (ProjectSubjectVO psv : res) {
            psv.setSumMonthSbuject(monthMap.get(psv.getId()));
            psv.setSumYearSbuject(yearMap.get(psv.getId()));
            psv.setSumAllSbuject(allMap.get(psv.getId()));
            psv.setSumMonthTaxSbuject(monthTaxMap.get(psv.getId()));
            psv.setSumYearTaxSbuject(yearTaxMap.get(psv.getId()));
            psv.setSumAllTaxSbuject(allTaxMap.get(psv.getId()));
        }
        List<Map> resultMapList = BeanMapper.mapList(res, Map.class);
        List<Map<String, Object>> subTree = ResultAsTree.createTreeData(resultMapList);
        List<Map<String, Object>> automatic = automatic(subTree, sumAll,sumTaxAll);
        return automatic;
    }

    private List<Map<String, Object>> automatic(List<Map<String, Object>> list, BigDecimal sumAll,BigDecimal sumTaxAll) {
        for (Map<String, Object> map : list) {
            List<Map<String, Object>> child = (List) map.get("children");
            if (child != null) {
                List<Map<String, Object>> newChildren = automatic(child, sumAll,sumTaxAll);
                map.put("children", newChildren);
                BigDecimal sumMonthSbuject = (BigDecimal) map.get("sumMonthSbuject");
                BigDecimal newSumMonthSbuject = MathUtil.safeAdd(sumMonthSbuject, childSum(newChildren, "sumMonthSbuject"));
                map.put("sumMonthSbuject", newSumMonthSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumMonthSbuject);
                BigDecimal sumMonthTaxSbuject = (BigDecimal) map.get("sumMonthTaxSbuject");
                BigDecimal newSumMonthTaxSbuject = MathUtil.safeAdd(sumMonthTaxSbuject, childSum(newChildren, "sumMonthTaxSbuject"));
                map.put("sumMonthTaxSbuject", newSumMonthTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumMonthTaxSbuject);

                BigDecimal sumYearSbuject = (BigDecimal) map.get("sumYearSbuject");
                BigDecimal newSumYearSbuject = MathUtil.safeAdd(sumYearSbuject, childSum(newChildren, "sumYearSbuject"));
                map.put("sumYearSbuject", newSumYearSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumYearSbuject);
                BigDecimal sumYearTaxSbuject = (BigDecimal) map.get("sumYearTaxSbuject");
                BigDecimal newSumYearTaxSbuject = MathUtil.safeAdd(sumYearTaxSbuject, childSum(newChildren, "sumYearTaxSbuject"));
                map.put("sumYearTaxSbuject", newSumYearTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumYearTaxSbuject);

                BigDecimal sumAllSbuject = (BigDecimal) map.get("sumAllSbuject");
                BigDecimal newSumAllSbuject = MathUtil.safeAdd(sumAllSbuject, childSum(newChildren, "sumAllSbuject"));
                map.put("sumAllSbuject", newSumAllSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumAllSbuject);
                BigDecimal sumAllTaxSbuject = (BigDecimal) map.get("sumAllTaxSbuject");
                BigDecimal newSumAllTaxSbuject = MathUtil.safeAdd(sumAllTaxSbuject, childSum(newChildren, "sumAllTaxSbuject"));
                map.put("sumAllTaxSbuject", newSumAllTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : newSumAllTaxSbuject);

                BigDecimal subjectRate = MathUtil.safeMultiply(MathUtil.safeDiv(newSumAllSbuject, sumAll), new BigDecimal("100"));
                map.put("subjectRate", subjectRate);
                BigDecimal subjectTaxRate = MathUtil.safeMultiply(MathUtil.safeDiv(newSumAllTaxSbuject, sumTaxAll), new BigDecimal("100"));
                map.put("subjectTaxRate", subjectTaxRate);
            } else {
                BigDecimal sumMonthSbuject = (BigDecimal) map.get("sumMonthSbuject");
                map.put("sumMonthSbuject", sumMonthSbuject == null||sumMonthSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumMonthSbuject);
                BigDecimal sumMonthTaxSbuject = (BigDecimal) map.get("sumMonthTaxSbuject");
                map.put("sumMonthTaxSbuject", sumMonthTaxSbuject == null||sumMonthTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumMonthTaxSbuject);

                BigDecimal sumYearSbuject = (BigDecimal) map.get("sumYearSbuject");
                map.put("sumYearSbuject", sumYearSbuject == null||sumYearSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumYearSbuject);
                BigDecimal sumYearTaxSbuject = (BigDecimal) map.get("sumYearTaxSbuject");
                map.put("sumYearTaxSbuject", sumYearTaxSbuject == null||sumYearTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumYearTaxSbuject);

                BigDecimal sumAllSbuject = (BigDecimal) map.get("sumAllSbuject");
                map.put("sumAllSbuject", sumAllSbuject == null||sumAllSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumAllSbuject);
                BigDecimal sumAllTaxSbuject = (BigDecimal) map.get("sumAllTaxSbuject");
                map.put("sumAllTaxSbuject", sumAllTaxSbuject == null||sumAllTaxSbuject.compareTo(BigDecimal.ZERO) == 0 ? null : sumAllTaxSbuject);

                BigDecimal subjectRate = MathUtil.safeMultiply(MathUtil.safeDiv(sumAllSbuject, sumAll), new BigDecimal("100"));
                map.put("subjectRate", subjectRate);
                BigDecimal subjectTaxRate = MathUtil.safeMultiply(MathUtil.safeDiv(sumAllTaxSbuject, sumTaxAll), new BigDecimal("100"));
                map.put("subjectTaxRate", subjectTaxRate);
            }
        }
        return list;
    }

    private BigDecimal childSum(List<Map<String, Object>> list, String colums) {
        BigDecimal allMny = BigDecimal.ZERO;
        for (Map<String, Object> map : list) {
            BigDecimal mny = (BigDecimal) map.get(colums);
            allMny = MathUtil.safeAdd(allMny, mny);
        }
        return allMny;
    }


}
