package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.vo.MechanDepreciationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.MechanDepreciationMapper;
import com.ejianc.business.cost.bean.MechanDepreciationEntity;
import com.ejianc.business.cost.service.IMechanDepreciationService;

/**
 * 机械折旧费用单
 * 
 * @author generator
 * 
 */
@Service("mechanDepreciationService")
public class MechanDepreciationServiceImpl extends BaseServiceImpl<MechanDepreciationMapper, MechanDepreciationEntity> implements IMechanDepreciationService{
    private static final String BILL_CODE = "MECHAN_CODE";;//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public MechanDepreciationVO saveOrUpdate(MechanDepreciationVO saveOrUpdateVO) {
        MechanDepreciationEntity entity = BeanMapper.map(saveOrUpdateVO, MechanDepreciationEntity.class);
        if(StringUtils.isBlank(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public MechanDepreciationVO queryDetail(Long id) {
        MechanDepreciationEntity entity = super.selectById(id);
        MechanDepreciationVO vo = BeanMapper.map(entity, MechanDepreciationVO.class);
        return vo;
    }
}
