/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.mapper.BudgetProjectMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectService")
public class BudgetProjectServiceImpl
extends BaseServiceImpl<BudgetProjectMapper, BudgetProjectEntity>
implements IBudgetProjectService {
    private static final String BILL_CODE_ROLE = "BUDGET_PRO_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetProjectDetailService detailsService;
    @Autowired
    private BudgetProjectMapper budgetProjectMapper;

    @Override
    public CommonResponse<BudgetProjectVO> saveOrUpdate(BudgetProjectVO saveorUpdateVO) {
        Object entities2;
        LambdaQueryWrapper lambda2;
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetProjectEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (BudgetProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetProjectEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (BudgetProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetProjectEntity.class));
            operateType = "add";
        }
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BudgetProjectEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            lambda2 = Wrappers.lambdaQuery();
            lambda2.eq(BudgetProjectEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
            lambda2.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda2.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            entities2 = super.list((Wrapper)lambda2);
            if (entities2 != null && entities2.size() > 0) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u505a\u8fc7\u9884\u7b97\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BudgetProjectEntity::getBillCode, (Object)saveorUpdateVO.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            lambda2 = Wrappers.lambdaQuery();
            lambda2.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda2.eq(BudgetProjectEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
            entities2 = super.list((Wrapper)lambda2);
            if (entities2 != null && entities2.size() > 0) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u505a\u8fc7\u9884\u7b97\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setBaseBudgetMoney(entity.getBudgetMny());
        entity.setBeforeChangeBudgetMny(entity.getBudgetMny());
        entity.setBaseLaborMny(entity.getLaborMny());
        entity.setBeforeChangeLaborMny(entity.getLaborMny());
        entity.setBaseMaterialMny(entity.getMaterialMny());
        entity.setBeforeChangeMaterialMny(entity.getMaterialMny());
        entity.setBaseMechanicalMny(entity.getMechanicalMny());
        entity.setBeforeChangeMechanicalMny(entity.getMechanicalMny());
        entity.setBaseOtherMny(entity.getOtherMny());
        entity.setBeforeChangeOtherMny(entity.getOtherMny());
        List detailsVos = saveorUpdateVO.getCheckList();
        int leaf = 0;
        int subject = 0;
        for (BudgetProjectDetailVO detailsVo : detailsVos) {
            if ("del".equals(detailsVo.getRowState()) || !detailsVo.getLeafFlag().booleanValue()) continue;
            ++leaf;
            if (detailsVo.getSubjectId() == null) continue;
            ++subject;
        }
        if (leaf == subject) {
            entity.setLinkedFlag(1);
            entity.setUnassociate(0);
        } else {
            entity.setLinkedFlag(0);
            entity.setUnassociate(leaf - subject);
        }
        super.saveOrUpdate((Object)entity);
        ArrayList<BudgetProjectDetailEntity> saveOrUpldates = new ArrayList<BudgetProjectDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (BudgetProjectDetailVO detailsVo : detailsVos) {
            BudgetProjectDetailEntity detailslist;
            detailsVo.setChangeType(Integer.valueOf(0));
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (BudgetProjectDetailEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetProjectDetailEntity.class));
                detailslist.setBudgetId(entity.getId());
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (BudgetProjectDetailEntity)((Object)BeanMapper.map((Object)detailsVo, BudgetProjectDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (BudgetProjectDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetProjectDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.detailsService.removeByIds(deleteIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public BudgetProjectVO queryDetail(Long id) {
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetProjectMapper.selectById(id));
        if (entity != null) {
            BudgetProjectVO contractVo = (BudgetProjectVO)BeanMapper.map((Object)((Object)entity), BudgetProjectVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_id", new Parameter("eq", (Object)contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (BudgetProjectDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)purchaseDetailss, BudgetProjectDetailVO.class);
                Collections.sort(resultMapList, new BudgetDetailComparatoeVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            return contractVo;
        }
        return null;
    }

    @Override
    public CommonResponse<BudgetProjectVO> pushCost(BudgetProjectVO pushVO) {
        List checkList = pushVO.getCheckList();
        int leaf = 0;
        int subject = 0;
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            for (BudgetProjectDetailVO detailsVo : checkList) {
                if (!detailsVo.getLeafFlag().booleanValue()) continue;
                ++leaf;
                if (detailsVo.getSubjectId() == null) continue;
                ++subject;
            }
            LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
            if (leaf == subject) {
                lambda.set(BudgetProjectEntity::getLinkedFlag, (Object)1);
                lambda.set(BudgetProjectEntity::getUnassociate, (Object)0);
            } else {
                lambda.set(BudgetProjectEntity::getLinkedFlag, (Object)0);
                lambda.set(BudgetProjectEntity::getUnassociate, (Object)(leaf - subject));
            }
            lambda.eq(BaseEntity::getId, (Object)pushVO.getId());
            super.update((Wrapper)lambda);
            List detailEntities = BeanMapper.mapList((Iterable)checkList, BudgetProjectDetailEntity.class);
            this.detailsService.saveOrUpdateBatch(detailEntities);
        }
        return CommonResponse.success((Object)this.queryDetail(pushVO.getId()));
    }
}

