package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryService;
import com.ejianc.business.budget.vo.BudgetProjectDetailHistoryVO;
import com.ejianc.business.budget.vo.BudgetProjectHistoryVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailHistoryComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetProjectHistoryMapper;
import com.ejianc.business.budget.bean.BudgetProjectHistoryEntity;
import com.ejianc.business.budget.service.IBudgetProjectHistoryService;

import java.util.Collections;
import java.util.List;

/**
 * 项目预算记录表
 * 
 * @author generator
 * 
 */
@Service("budgetProjectHistoryService")
public class BudgetProjectHistoryServiceImpl extends BaseServiceImpl<BudgetProjectHistoryMapper, BudgetProjectHistoryEntity> implements IBudgetProjectHistoryService{

    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;

    @Override
    public BudgetProjectHistoryVO queryDetailByChangeId(Long id) {

        BudgetProjectHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<BudgetProjectHistoryEntity>().eq("change_id", id));
        if(historyEntity !=null){
            BudgetProjectHistoryVO historyVo = BeanMapper.map(historyEntity, BudgetProjectHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budget_history_id", new Parameter(QueryParam.EQ, historyEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<BudgetProjectDetailHistoryEntity> historyDetailEntities = historyDetailService.queryList(queryParam, false);

            if(historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<BudgetProjectDetailHistoryVO> detailVos = BeanMapper.mapList(historyDetailEntities, BudgetProjectDetailHistoryVO.class);
                //实现排序
                Collections.sort(detailVos,new BudgetDetailHistoryComparatoeVo());
                for(BudgetProjectDetailHistoryVO cdEntity:detailVos){
                    cdEntity.setTid(cdEntity.getBudgetDetailId().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                    //cdEntity.setRowState("edit");
                }
                historyVo.setCheckList(TreeNodeBUtil.buildTree(detailVos));
            }

            return historyVo;
        }
        return null;
    }
}
