package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 最终其他成本汇总
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_fin_other_detail")
public class CostFinOtherDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    @TableField(value="cost_type_Id")
    private String costTypeId; // 费用类别
    @TableField(value="cost_analysis")
    private String costAnalysis; // 费用分析
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称
    @TableField(value="estimated_amount")
    private BigDecimal estimatedAmount; // 不含税预估金额(元)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="estimated_tax_amount")
    private BigDecimal estimatedTaxAmount; // 含税预估金额(元)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="accounting_id")
    private String accountingId; // 变更状态	
    @TableField(value="accounting_name")
    private String accountingName; // 变更状态名称
    @TableField(value="fin_cost_id")
    private Long finCostId; // 成本关门预估id
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCostTypeId() {
        return costTypeId;
    }

    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }
    public String getCostAnalysis() {
        return costAnalysis;
    }

    public void setCostAnalysis(String costAnalysis) {
        this.costAnalysis = costAnalysis;
    }
    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public BigDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setEstimatedAmount(BigDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getEstimatedTaxAmount() {
        return estimatedTaxAmount;
    }

    public void setEstimatedTaxAmount(BigDecimal estimatedTaxAmount) {
        this.estimatedTaxAmount = estimatedTaxAmount;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAccountingId() {
        return accountingId;
    }

    public void setAccountingId(String accountingId) {
        this.accountingId = accountingId;
    }
    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }
    public Long getFinCostId() {
        return finCostId;
    }

    public void setFinCostId(Long finCostId) {
        this.finCostId = finCostId;
    }
    
}
