package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 合同成本关门预估变更控制明细
 *
 * @author generator
 *
 */
@TableName("ejc_forecast_contract_detail_change")
public class ForecastContractDetailChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    @TableField(value="contract_type")
    private String contractType; // 合同类型
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="sub_org")
    private String subOrg; // 分包企业
    @TableField(value="sub_org_id")
    private Long subOrgId; // 分包企业主键
    @TableField(value="amount_settled")
    private BigDecimal amountSettled; // 含税已结算
    @TableField(value="estimated_amount_notax")
    private BigDecimal estimatedAmountNotax; // 原不含税预估成本
    @TableField(value="increase_estimated_amount")
    private BigDecimal increaseEstimatedAmount; // 含税预估总成本
    @TableField(value="estimated_amount_sum")
    private BigDecimal estimatedAmountSum; // 不含税预估总成本
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="forecast_id")
    private Long forecastId; // 成本关门预估主键
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="accounting_id")
    private String accountingId; // 变更状态
    @TableField(value="accounting_name")
    private String accountingName; // 变更状态名称
    @TableField(value="estimated_amount")
    private BigDecimal estimatedAmount; // 原预估成本
    @TableField(value="estimated_amount_tax")
    private BigDecimal estimatedAmountTax; // 原预估成本税金
    @TableField(value="change_status")
    private Long changeStatus; // 变更状态
    @TableField(value="increase_estimated_amount_notax")
    private BigDecimal increaseEstimatedAmountNotax; // 不含税预估总成本
    @TableField(value="increase_estimated_amount_tax")
    private BigDecimal increaseEstimatedAmountTax; // 预估总成本税金
    @TableField(value="increase_costs")
    private BigDecimal increaseCosts; // 增加成本费用（含税）
    @TableField(value="cost_change_forecast_id")
    private Long costChangeForecastId; // 成本关门预估id
    @TableField(value="increase_costs_notax")
    private BigDecimal increaseCostsNotax; // 增加成本费用（不含税）
    @TableField(value="increase_costs_tax")
    private BigDecimal increaseCostsTax; // 增加成本费用（税金）
    @TableField(value="brief_description")
    private String briefDescription; // 预估成本简要说明
    @TableField(value="isend")
    private String isend; // 是否做过完工/最终结算（Y N）
    @TableField(value="source_forecast_id")
    private Long sourceForecastId; // 成本关门预估id
    @TableField(value="source_forecast_contract_id")
    private Long sourceForecastContractId; // 成本关门预估合同明细id
    @TableField(value="amount_settled_notax")
    private BigDecimal amountSettledNotax; // 不含税已结算
    @TableField(value="amount_settled_tax")
    private BigDecimal amountSettledTax; // 已结算税金
    @TableField(value="accounting_f_j")
    private String accountingFJ; // 上传附件

    public String getAccountingFJ() {
        return accountingFJ;
    }

    public void setAccountingFJ(String accountingFJ) {
        this.accountingFJ = accountingFJ;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getSubOrg() {
        return subOrg;
    }

    public void setSubOrg(String subOrg) {
        this.subOrg = subOrg;
    }
    public Long getSubOrgId() {
        return subOrgId;
    }

    public void setSubOrgId(Long subOrgId) {
        this.subOrgId = subOrgId;
    }
    public BigDecimal getAmountSettled() {
        return amountSettled;
    }

    public void setAmountSettled(BigDecimal amountSettled) {
        this.amountSettled = amountSettled;
    }
    public BigDecimal getEstimatedAmountNotax() {
        return estimatedAmountNotax;
    }

    public void setEstimatedAmountNotax(BigDecimal estimatedAmountNotax) {
        this.estimatedAmountNotax = estimatedAmountNotax;
    }
    public BigDecimal getIncreaseEstimatedAmount() {
        return increaseEstimatedAmount;
    }

    public void setIncreaseEstimatedAmount(BigDecimal increaseEstimatedAmount) {
        this.increaseEstimatedAmount = increaseEstimatedAmount;
    }
    public BigDecimal getEstimatedAmountSum() {
        return estimatedAmountSum;
    }

    public void setEstimatedAmountSum(BigDecimal estimatedAmountSum) {
        this.estimatedAmountSum = estimatedAmountSum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getForecastId() {
        return forecastId;
    }

    public void setForecastId(Long forecastId) {
        this.forecastId = forecastId;
    }
    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    public String getAccountingId() {
        return accountingId;
    }

    public void setAccountingId(String accountingId) {
        this.accountingId = accountingId;
    }
    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }
    public BigDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setEstimatedAmount(BigDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }
    public BigDecimal getEstimatedAmountTax() {
        return estimatedAmountTax;
    }

    public void setEstimatedAmountTax(BigDecimal estimatedAmountTax) {
        this.estimatedAmountTax = estimatedAmountTax;
    }
    public Long getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Long changeStatus) {
        this.changeStatus = changeStatus;
    }
    public BigDecimal getIncreaseEstimatedAmountNotax() {
        return increaseEstimatedAmountNotax;
    }

    public void setIncreaseEstimatedAmountNotax(BigDecimal increaseEstimatedAmountNotax) {
        this.increaseEstimatedAmountNotax = increaseEstimatedAmountNotax;
    }
    public BigDecimal getIncreaseEstimatedAmountTax() {
        return increaseEstimatedAmountTax;
    }

    public void setIncreaseEstimatedAmountTax(BigDecimal increaseEstimatedAmountTax) {
        this.increaseEstimatedAmountTax = increaseEstimatedAmountTax;
    }
    public BigDecimal getIncreaseCosts() {
        return increaseCosts;
    }

    public void setIncreaseCosts(BigDecimal increaseCosts) {
        this.increaseCosts = increaseCosts;
    }
    public Long getCostChangeForecastId() {
        return costChangeForecastId;
    }

    public void setCostChangeForecastId(Long costChangeForecastId) {
        this.costChangeForecastId = costChangeForecastId;
    }
    public BigDecimal getIncreaseCostsNotax() {
        return increaseCostsNotax;
    }

    public void setIncreaseCostsNotax(BigDecimal increaseCostsNotax) {
        this.increaseCostsNotax = increaseCostsNotax;
    }
    public BigDecimal getIncreaseCostsTax() {
        return increaseCostsTax;
    }

    public void setIncreaseCostsTax(BigDecimal increaseCostsTax) {
        this.increaseCostsTax = increaseCostsTax;
    }
    public String getBriefDescription() {
        return briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }
    public String getIsend() {
        return isend;
    }

    public void setIsend(String isend) {
        this.isend = isend;
    }
    public Long getSourceForecastId() {
        return sourceForecastId;
    }

    public void setSourceForecastId(Long sourceForecastId) {
        this.sourceForecastId = sourceForecastId;
    }
    public Long getSourceForecastContractId() {
        return sourceForecastContractId;
    }

    public void setSourceForecastContractId(Long sourceForecastContractId) {
        this.sourceForecastContractId = sourceForecastContractId;
    }
    public BigDecimal getAmountSettledNotax() {
        return amountSettledNotax;
    }

    public void setAmountSettledNotax(BigDecimal amountSettledNotax) {
        this.amountSettledNotax = amountSettledNotax;
    }
    public BigDecimal getAmountSettledTax() {
        return amountSettledTax;
    }

    public void setAmountSettledTax(BigDecimal amountSettledTax) {
        this.amountSettledTax = amountSettledTax;
    }

}
