package com.ejianc.business.cost.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.cost.bean.CostClosingLastChangeEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;

/**
 * 最终成本关门通知变更
 * 
 * @author generator
 * 
 */
@Mapper
public interface CostClosingLastChangeMapper extends BaseCrudMapper<CostClosingLastChangeEntity> {

    @Select("select coalesce((select last_output_value from ejc_cost_closing_last_change where dr = '0' and project_id = #{projectId} ORDER BY create_time desc limit 1),0) as amount")
    BigDecimal notax(@Param("projectId") Long projectId);

    @Select("select count(id) from ejc_cost_closing_last_change where dr = '0' and project_id = #{projectId}")
    Integer countByProject(Long projectId);
}
