package com.ejianc.business.cost.mapper;

import com.ejianc.business.cost.bean.*;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 合同成本·关门预估控制明细
 *
 * @author generator
 *
 */
@Mapper
public interface ForecastContractDetailMapper extends BaseCrudMapper<ForecastContractDetailEntity> {

    List<ForecastContractDetailEntity> querySubContractByProjectId(@Param("projectId") String projectId,@Param("contractId") String contractId);

    List<ForecastMaterialcontractDetailEntity> querySubContractByProjectIdMaterial(@Param("projectId") String projectId);

    List<ForecastMachinecontractDetailEntity> querySubContractByProjectIdMachine(@Param("projectId") String projectId);

    List<ForecastOthercontractDetailEntity> querySubContractByProjectIdOther(@Param("projectId") String projectId);

    Integer querySubFinish(@Param("contractId") Long contractId);

    Integer queryCostFinish(@Param("projectId") String projectId);

    List<ForecastContractDetailEntity> querySubContractByIdLW(@Param("projectId") Long projectId);

    List<ForecastContractDetailEntity> querySubContractByIdZY(@Param("projectId") Long projectId);

    List<String> queryallcontract(@Param("id") Long id);

    List<String> queryprojectcontract(@Param("projectId") Long projectId);

    @Select("select id from ejc_cost_closing_forecast where dr = '0' and project_id = #{projectId}")
    Long queryId(@Param("projectId") String projectId);

    List<ForecastContractDetailEntity> querySubdetailLW(Long fin);

    List<ForecastContractDetailEntity> querySubdetailZY(Long fin);

    List<ForecastOtherDetailEntity> queryotherdetail(Long fin);

    List<ForecastMaterialcontractDetailEntity> queryMaterialdetail(Long fin);

    List<ForecastMachinecontractDetailEntity> queryMachinedetail(Long fin);

    List<ForecastOthercontractDetailEntity> queryOthercontractdetail(Long fin);
}
