package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cost.bean.AccountingOrgEntity;
import com.ejianc.business.cost.service.IAccountingOrgService;
import com.ejianc.business.cost.vo.AccountingOrgVO;
import com.ejianc.business.cost.vo.AccountingProjectImportVO;
import com.ejianc.business.cost.vo.AccountingProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.AccountingProjectMapper;
import com.ejianc.business.cost.bean.AccountingProjectEntity;
import com.ejianc.business.cost.service.IAccountingProjectService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目核算对象实体
 *
 * @author generator
 */
@Service("accountingProjectService")
public class AccountingProjectServiceImpl extends BaseServiceImpl<AccountingProjectMapper, AccountingProjectEntity> implements IAccountingProjectService {

    @Autowired
    private IAccountingOrgService accountingOrgService;

    @Override
    public CommonResponse<AccountingProjectVO> saveOrUpdate(AccountingProjectVO saveorUpdateVO) {
        AccountingProjectEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, AccountingProjectEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            entity = BeanMapper.map(saveorUpdateVO, AccountingProjectEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                AccountingProjectEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public Boolean delRefCheck(List<Long> ids) {
        LambdaQueryWrapper<AccountingProjectEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(AccountingProjectEntity::getDr, 0);
        lambda.in(AccountingProjectEntity::getOrgAccountingId, ids);
        List<AccountingProjectEntity> list = super.list(lambda);
        return list != null && list.size() > 0;
    }

    @Override
    public void importOrgSubject(AccountingProjectImportVO importVo) {
        List<AccountingOrgVO> detailList = importVo.getDetailList();
        List<Long> ids = detailList.stream().map(AccountingOrgVO::getId).collect(Collectors.toList());

        // 添加父级
        List<String> innerCodeList = detailList.stream().map(AccountingOrgVO::getInnerCode).collect(Collectors.toList());
        List<Long> innerCodes = new ArrayList<>();
        innerCodeList.forEach(x->{
            if(StringUtils.isNotEmpty(x)){
                innerCodes.addAll(Arrays.asList(x.split(",")).stream().map(y-> Long.valueOf(y)).filter(y->!ids.contains(y)).collect(Collectors.toList()));
            }
        });
        if(CollectionUtils.isNotEmpty(innerCodes)){
            List<AccountingOrgEntity> innerList = (List<AccountingOrgEntity>) accountingOrgService.listByIds(innerCodes);
            ids.addAll(innerCodes);
            detailList.addAll(BeanMapper.mapList(innerList, AccountingOrgVO.class));
        }

        LambdaQueryWrapper<AccountingProjectEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(AccountingProjectEntity::getDr, 0);
        lambda.eq(AccountingProjectEntity::getProjectId, importVo.getProjectId());
        lambda.in(AccountingProjectEntity::getOrgAccountingId, ids);
        List<AccountingProjectEntity> list = super.list(lambda);
        List<Long> oldIds = new ArrayList<>();
        Map<Long, Long> parentMap = new HashMap<>();
        for (AccountingProjectEntity spe : list) {
            parentMap.put(spe.getOrgAccountingId(), spe.getId());
            oldIds.add(spe.getOrgAccountingId());
        }
        List<AccountingProjectEntity> saveList = new ArrayList<>();
        for (AccountingOrgVO vo : detailList) {
            if (!oldIds.contains(vo.getId())) {
                AccountingProjectEntity entity = new AccountingProjectEntity();
                long id = IdWorker.getId();
                entity.setId(id);
                entity.setAccountingCode(vo.getAccountingCode());
                entity.setAccountingName(vo.getAccountingName());
                entity.setMemo(vo.getMemo());
                entity.setOrgId(importVo.getOrgId());
                entity.setOrgName(importVo.getOrgName());
                entity.setProjectId(importVo.getProjectId());
                entity.setProjectName(importVo.getProjectName());
                entity.setOrgAccountingId(vo.getId());
                entity.setParentId(vo.getParentId());
                entity.setInnerCode(vo.getInnerCode());
                parentMap.put(vo.getId(), id);
                saveList.add(entity);
            }
        }

        if (saveList.size() > 0) {
            for (AccountingProjectEntity spe : saveList) {
                spe.setParentId(parentMap.get(spe.getParentId()));
                String innerCode = spe.getInnerCode();
                String[] split = innerCode.split(",");
                String newInnerCode = "";
                for (int i = 0; i < split.length; i++) {
                    Long aLong = parentMap.get(Long.parseLong(split[i]));
                    if (i == 0) {
                        newInnerCode = aLong.toString();
                    } else {
                        newInnerCode = newInnerCode + "," + aLong.toString();
                    }
                }
                spe.setInnerCode(newInnerCode);
            }
            super.saveBatch(saveList);
        }
    }
}
