package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.MechanDepreciationDetailEntity;
import com.ejianc.business.cost.bean.MechanDepreciationEntity;
import com.ejianc.business.cost.controller.api.CostDetailApi;
import com.ejianc.business.cost.service.IMechanDepreciationService;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.auth.session.SessionManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("mechanDepreciation") 
public class MechanDepreciationBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IMechanDepreciationService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private CostDetailApi costDetailApi;
	private static final String MECHAN_DEPRECIATION = "MECHAN_DEPRECIATION";
	private static final String MECHAN_DEPRECIATION_DETAIL = "MECHAN_DEPRECIATION_DETAIL";

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MechanDepreciationEntity entity = service.selectById(billId);
		processCost(entity);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		delCost(billId);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	public void processCost(MechanDepreciationEntity entity) {
		boolean canPush = true;
		List<CostDetailVO> list = new ArrayList<>();
		if (ListUtil.isNotEmpty(entity.getDetailList())) {
			for (int i = 0; i < entity.getDetailList().size(); i++) {
				MechanDepreciationDetailEntity sub = entity.getDetailList().get(i);
				if (sub.getSubjectId() != null && sub.getSubjectId() > 0L && sub.getAccountingId() != null && sub.getAccountingId() > 0L) {
					CostDetailVO c = new CostDetailVO();
					c.setSubjectId(sub.getSubjectId());
					c.setOrgSubjectId(sub.getOrgSubjectId());
					c.setAccountingId(sub.getAccountingId());
					c.setOrgAccountingId(sub.getOrgAccountingId());
					c.setSourceId(entity.getId());
					c.setSourceDetailId(sub.getId());
					c.setProjectId(entity.getProjectId());
					c.setHappenTaxMny(sub.getSumMny() == null ? new BigDecimal("0.00") : sub.getSumMny());
					c.setHappenMny(sub.getSumMny() == null ? new BigDecimal("0.00") : sub.getSumMny());
					c.setHappenDate(entity.getCountDate());
					c.setMemo(sub.getMemo());
					c.setCreateUserName(sessionManager.getUserContext().getUserName());
					c.setSourceType(MECHAN_DEPRECIATION);
					c.setSourceTabType(MECHAN_DEPRECIATION_DETAIL);
					list.add(c);
				} else {
					canPush = false;
					break;
				}
			}

		}
		if (canPush) {
			CommonResponse<CostDetailVO> response = costDetailApi.saveSubject(list);
			logger.info("推送成本 机械折旧费 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
		} else {
			CommonResponse<CostDetailVO> response = costDetailApi.deleteCostDetail(entity.getId());
			logger.info("删除成本 机械折旧费 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
		}
	}
	public void delCost(Long id) {
		CommonResponse<CostDetailVO> response = costDetailApi.deleteCostDetail(id);
		logger.info("删除成本 机械折旧费 结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + id);
	}
}
