package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.utils.ExcelImportUtil;
import com.ejianc.business.cost.bean.TargetLiabilityCostDetailEntity;
import com.ejianc.business.cost.service.ITargetLiabilityCostDetailService;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.cost.vo.TargetLiabilityCostDetailVO;
import com.ejianc.business.cost.vo.TargetLiabilityCostVO;
import com.ejianc.business.cost.vo.comparator.TargetCostDetailComparatorVo;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.TargetLiabilityCostMapper;
import com.ejianc.business.cost.bean.TargetLiabilityCostEntity;
import com.ejianc.business.cost.service.ITargetLiabilityCostService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * 目标责任成本
 * 
 * @author generator
 * 
 */
@Service("targetLiabilityCostService")
public class TargetLiabilityCostServiceImpl extends BaseServiceImpl<TargetLiabilityCostMapper, TargetLiabilityCostEntity> implements ITargetLiabilityCostService{

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ITargetLiabilityCostDetailService detailService;

    private static final String BILL_CODE = "Target_Liability_Cost";

    @Override
    public CommonResponse<TargetLiabilityCostVO> saveOrUpdate(TargetLiabilityCostVO saveorUpdateVO) {
        this.validate(saveorUpdateVO);
        TargetLiabilityCostEntity entity = BeanMapper.map(saveorUpdateVO, TargetLiabilityCostEntity.class);
        if(StringUtils.isBlank(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setDetailList(null);
        this.saveOrUpdate(entity, false);

        List<TargetLiabilityCostDetailVO> detailsVos = saveorUpdateVO.getDetailList();
        List<TargetLiabilityCostDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(TargetLiabilityCostDetailVO detailsVo:detailsVos) {
            if("add".equals(detailsVo.getRowState())) {
                TargetLiabilityCostDetailEntity detailslist = BeanMapper.map(detailsVo, TargetLiabilityCostDetailEntity.class);
                detailslist.setTargetLiabilityId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
            }else if("edit".equals(detailsVo.getRowState())) {
                TargetLiabilityCostDetailEntity detailslist = BeanMapper.map(detailsVo, TargetLiabilityCostDetailEntity.class);
                saveOrUpldates.add(detailslist);
            } else if("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        if(saveOrUpldates.size() > 0) {
            detailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            //维护父子级关系
            Map<String,Long> idMap=new HashMap<>();
            BigDecimal noTaxMny=new BigDecimal(0);
            BigDecimal incomeMny=new BigDecimal(0);
            BigDecimal Lr=new BigDecimal(0);
            for(TargetLiabilityCostDetailEntity cdEntity:saveOrUpldates){
				if("不含税目标责任成本".equals(cdEntity.getName())) {
					noTaxMny=cdEntity.getDetailMny()!=null?cdEntity.getDetailMny():new BigDecimal(0);
				}
				if("不含税有效收入".equals(cdEntity.getName())) {
					incomeMny=cdEntity.getDetailMny()!=null?cdEntity.getDetailMny():new BigDecimal(0);
				}
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(TargetLiabilityCostDetailEntity cdEntity:saveOrUpldates){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if("劳务费".equals(cdEntity.getName())||"材料费".equals(cdEntity.getName())||"主材费".equals(cdEntity.getName())||"机械费".equals(cdEntity.getName())||"专业分包工程费".equals(cdEntity.getName())||"间接费".equals(cdEntity.getName())) {
                	if(noTaxMny.compareTo(new BigDecimal(0))!=0) {
                		BigDecimal mny=cdEntity.getDetailMny() !=null?cdEntity.getDetailMny():new BigDecimal(0);
                		BigDecimal scale=mny.multiply(new BigDecimal(100)).divide(noTaxMny,2,BigDecimal.ROUND_HALF_UP);
                		cdEntity.setScale(scale.toString());
                	}
                }
                if("项目目标利润额".equals(cdEntity.getName())) {
                	if(incomeMny.compareTo(new BigDecimal(0))!=0) {
                    	Lr=incomeMny.subtract(noTaxMny);
                    	cdEntity.setDetailMny(Lr);
                	}
                }
                if("项目目标利润率(不含税)".equals(cdEntity.getName())) {
                	if(incomeMny.compareTo(new BigDecimal(0))!=0) {
                		cdEntity.setDetailMny(Lr.multiply(new BigDecimal(100)).divide(incomeMny,2,BigDecimal.ROUND_HALF_UP));
                		entity.setTargetRate(cdEntity.getDetailMny());
                		this.saveOrUpdate(entity, false);
                	}
                	
                }
            }
            detailService.saveOrUpdateBatch(saveOrUpldates,saveOrUpldates.size(),false);
        }
        if(deleteIds.size() > 0) {
            detailService.removeByIds(deleteIds, false);
        }


        return CommonResponse.success(queryDetail(entity.getId()));

    }


    private void validate(TargetLiabilityCostVO saveorUpdateVO) {
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<TargetLiabilityCostEntity> lambda = Wrappers.<TargetLiabilityCostEntity>lambdaQuery();
            lambda.eq(TargetLiabilityCostEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(TargetLiabilityCostEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambda.ne(TargetLiabilityCostEntity::getId, saveorUpdateVO.getId());
            List<TargetLiabilityCostEntity> entities = super.list(lambda);
            if(CollectionUtils.isNotEmpty(entities)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //新增   校验合同编号是否重复
            LambdaQueryWrapper<TargetLiabilityCostEntity> lambda = Wrappers.<TargetLiabilityCostEntity>lambdaQuery();
            lambda.eq(TargetLiabilityCostEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambda.eq(TargetLiabilityCostEntity::getBillCode, saveorUpdateVO.getBillCode());
            List<TargetLiabilityCostEntity> entities = super.list(lambda);
            if(CollectionUtils.isNotEmpty(entities)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
    }

    @Override
    public TargetLiabilityCostVO queryDetail(Long id) {
        TargetLiabilityCostEntity entity = super.selectById(id);
        if(entity != null) {
            TargetLiabilityCostVO liabilityCostVO = BeanMapper.map(entity, TargetLiabilityCostVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("targetLiabilityId", new Parameter(QueryParam.EQ, liabilityCostVO.getId()));
            List<TargetLiabilityCostDetailEntity> detailEntityList = detailService.queryList(queryParam, false);
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailEntityList)) {
                for(TargetLiabilityCostDetailEntity detailEntity:detailEntityList){
                    detailEntity.setTid(detailEntity.getId().toString());
                    detailEntity.setTpid(detailEntity.getParentId()!= null&&detailEntity.getParentId()>0?detailEntity.getParentId().toString():"");
                    detailEntity.setRowState("edit");
                }

                List<TargetLiabilityCostDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, TargetLiabilityCostDetailVO.class);
                //实现排序
                //Collections.sort(resultMapList,new TargetCostDetailComparatorVo());
                liabilityCostVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }

            return liabilityCostVO;
        }
        return null;
    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<TargetLiabilityCostDetailVO> detailVoList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    TargetLiabilityCostDetailVO vo = new TargetLiabilityCostDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex,id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第"+(i+2)+"行序号和第" + (indexMap.get(detailIndex)+2) + "行重复");
                    }else{
                        indexMap.put(detailIndex,i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"[编码为空]";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"[名称为空]";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setFeature(datas.get(3));//特征

                    vo.setUnit(datas.get(4));//单位

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setNum(null);
                        warnType = warnType+"[工程量为空]";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType+"[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setDetailTaxRate(null);
                    } else {
                        try {
                            vo.setDetailTaxRate(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setDetailTaxRate(null);
                            warnType = warnType+"[税率只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(7))) {
                        vo.setDetailPrice(null);
                    } else {
                        try {
                            vo.setDetailPrice(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setDetailPrice(null);
                            warnType = warnType+"[综合单价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(8))) {
                        vo.setDetailTaxPrice(null);
                    } else {
                        try {
                            vo.setDetailTaxPrice(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setDetailTaxPrice(null);
                            warnType = warnType+"[综合单价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(9))) {
                        vo.setDetailMny(null);
                    } else {
                        try {
                            vo.setDetailMny(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setDetailMny(null);
                            warnType = warnType+"[合价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {
                        vo.setDetailTaxMny(null);
                    } else {
                        try {
                            vo.setDetailTaxMny(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setDetailTaxMny(null);
                            warnType = warnType+"[合价只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(11))) {
                        vo.setDetailTax(null);
                    } else {
                        try {
                            vo.setDetailTax(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            vo.setDetailTax(null);
                            warnType = warnType+"[税额只能为数字或小数]";
                            flag = true;
                        }
                    }

                    vo.setMemo(datas.get(12));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    detailVoList.add(vo);
                }

                for(TargetLiabilityCostDetailVO tVo:detailVoList){
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }

                new TaxCalculateUtil<TargetLiabilityCostDetailVO>().calculate(detailVoList);
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList",allList.get(0));
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }


	@Override
	public List<TargetLiabilityCostDetailVO> queryDetailTemp() {
		 //获取
         List<TargetLiabilityCostDetailEntity> detailEntityList = detailService.queryDetailTemp();
         Map<String,String> tidMap = new HashMap<>();
         if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailEntityList)) {
             for(TargetLiabilityCostDetailEntity detailEntity:detailEntityList){
            	 String id = UUID.randomUUID().toString().replaceAll("-", "");
            	 String detailIndex=detailEntity.getDetailIndex();
            	 String name = detailEntity.getName();
            	 String[] split = detailIndex.split("[-/.]");
            	 detailEntity.setTid(id);
            	 tidMap.put(detailIndex,id);
            	 switch (name) {
				case "直接工程费":
					detailEntity.setTpid(tidMap.get("2"));
					break;
				case "专业分包工程费":
					detailEntity.setTpid(tidMap.get("2"));
					break;
				case"其他直接费":
					detailEntity.setTpid(tidMap.get("2"));
					break;
				case"间接费":
					detailEntity.setTpid(tidMap.get("2"));
					break;
				case"附加税金":
					detailEntity.setTpid(tidMap.get("2"));
					break;
				case"其他费用":
					detailEntity.setTpid(tidMap.get("2"));
					break;
				case"合作方收取的管理费":
					detailEntity.setTpid(tidMap.get("2"));
					break;
				case"劳务费":
					detailEntity.setTpid(tidMap.get("2.1"));
					break;
				case"材料费":
					detailEntity.setTpid(tidMap.get("2.1"));
					break;
				case"机械费":
					detailEntity.setTpid(tidMap.get("2.1"));
					break;
				case"管理费等":
					detailEntity.setTpid(tidMap.get("2.4"));
					break;
				case"安全文明施工费":
					detailEntity.setTpid(tidMap.get("2.4"));
					break;
				case"其他间接费":
					detailEntity.setTpid(tidMap.get("2.4"));
					break;
				default:
					break;
				}
                 if (split.length > 2) {
                	 detailEntity.setTpid(tidMap.get(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1)));
                 }
                 detailEntity.setRowState("add");
             }
         }
             List<TargetLiabilityCostDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, TargetLiabilityCostDetailVO.class);
             resultMapList.forEach(e->{
            	 e.setShadowId(e.getTid());
             });
             //实现排序
             //Collections.sort(resultMapList,new TargetCostDetailComparatorVo());
		return buildTree(resultMapList);
	}

	  public static List<TargetLiabilityCostDetailVO> buildTree(List<TargetLiabilityCostDetailVO> values) {
		    Map<String, TargetLiabilityCostDetailVO> nodeMap = new HashMap<>();
		    List<TargetLiabilityCostDetailVO> result = new ArrayList<>();
		    List<TargetLiabilityCostDetailVO> emptyValueList = new ArrayList<>();
		    for (TargetLiabilityCostDetailVO value : values) {
		      if (null==value||value.getTpid()==null) {
		        result.add(value);
		      } else {
		    	  TargetLiabilityCostDetailVO parentNode = nodeMap.get(value.getTpid());
		        if (parentNode == null) {
		          emptyValueList.add(value);
		        } else {
		          parentNode.getChildren().add(value);
		        }
		      }
		      nodeMap.put(value.getTid(), value);
		    }
		    if (!emptyValueList.isEmpty()) {
		      for (TargetLiabilityCostDetailVO value : emptyValueList) {
		    	  TargetLiabilityCostDetailVO parentNode = nodeMap.get(value.getTpid());
		        if (parentNode == null) {
		          result.add(value);
		        } else {
		          parentNode.getChildren().add(value);
		        }
		      }
		    }
		    return result;
		  }

}
