/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CostClosingLastChangeEntity;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import com.ejianc.business.cost.mapper.CostClosingLastMapper;
import com.ejianc.business.cost.service.ICostClosingLastChangeService;
import com.ejianc.business.cost.service.ICostClosingLastService;
import com.ejianc.business.cost.vo.CostClosingLastChangeVO;
import com.ejianc.business.cost.vo.CostClosingLastVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costClosingLastChange"})
public class CostClosingLastChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICostClosingLastChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CostClosingLastMapper costClosingLastMapper;
    @Autowired
    private ICostClosingLastService costClosingLastService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostClosingLastChangeVO> saveOrUpdate(@RequestBody CostClosingLastChangeVO saveOrUpdateVO) {
        CommonResponse<CostClosingLastChangeVO> commonResponse = this.service.saveOrUpdate(saveOrUpdateVO);
        return commonResponse;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostClosingLastChangeVO> queryDetail(Long id) {
        CostClosingLastChangeEntity entity = (CostClosingLastChangeEntity)((Object)this.service.selectById(id));
        CostClosingLastChangeVO vo = (CostClosingLastChangeVO)BeanMapper.map((Object)((Object)entity), CostClosingLastChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostClosingLastChangeVO> vos) {
        Long id = vos.get(0).getId();
        CostClosingLastChangeEntity vo = (CostClosingLastChangeEntity)((Object)this.service.selectById(id));
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        List<CostClosingLastChangeEntity> list = this.costClosingLastMapper.querylastchangeList(vo.getClosingLastId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        if (list.isEmpty()) {
            updateWrapper.set(CostClosingLastEntity::getChangeStatus, (Object)Character.valueOf('1'));
            updateWrapper.set(CostClosingLastEntity::getLastCostClosingTime, (Object)((CostClosingLastEntity)((Object)this.costClosingLastMapper.selectById(vo.getClosingLastId()))).getOldCostClosingTime());
            updateWrapper.set(CostClosingLastEntity::getDays, (Object)"0");
            updateWrapper.eq(BaseEntity::getId, (Object)vo.getClosingLastId());
            this.costClosingLastService.update((Wrapper)updateWrapper);
        } else {
            updateWrapper.set(CostClosingLastEntity::getLastCostClosingTime, (Object)list.get(0).getLastCostClosingTime());
            LocalDate lastCostClosingTimelocalDate = list.get(0).getLastCostClosingTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate oldCostClosingTimelocalDate = ((CostClosingLastEntity)((Object)this.costClosingLastMapper.selectById(vo.getClosingLastId()))).getOldCostClosingTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            long days = ChronoUnit.DAYS.between(oldCostClosingTimelocalDate, lastCostClosingTimelocalDate);
            updateWrapper.set(CostClosingLastEntity::getDays, (Object)String.valueOf(days));
            updateWrapper.eq(BaseEntity::getId, (Object)vo.getClosingLastId());
            this.costClosingLastService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CostClosingLastChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostClosingLastChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CostClosingLastChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCostClosingLastChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CostClosingLastChangeVO>> refCostClosingLastChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostClosingLastChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostClosingLastChangeVO> queryDetailChange(@RequestParam Long id) {
        CostClosingLastChangeVO vo = this.service.queryDetailChange(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostClosingLastVO> queryDetailRecord(Long id) {
        CostClosingLastVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

