package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.ejianc.business.cost.bean.CostCategoryEntity;
import com.ejianc.business.cost.bean.SubjectProjectEntity;
import com.ejianc.business.cost.mapper.ForecastOtherDetailChangeMapper;
import com.ejianc.business.cost.service.ISubjectProjectService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.ForecastOtherDetailChangeEntity;
import com.ejianc.business.cost.service.IForecastOtherDetailChangeService;
import com.ejianc.business.cost.vo.ForecastOtherDetailChangeVO;

/**
 * 其他预估成本关门变更控制明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("forecastOtherDetailChange")
public class ForecastOtherDetailChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IForecastOtherDetailChangeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ForecastOtherDetailChangeMapper baseMapper;

    @Autowired
    private ISubjectProjectService subjectProjectService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ForecastOtherDetailChangeVO> saveOrUpdate(@RequestBody ForecastOtherDetailChangeVO saveOrUpdateVO) {
    	ForecastOtherDetailChangeEntity entity = BeanMapper.map(saveOrUpdateVO, ForecastOtherDetailChangeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ForecastOtherDetailChangeVO vo = BeanMapper.map(entity, ForecastOtherDetailChangeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ForecastOtherDetailChangeVO> queryDetail(Long id) {
    	ForecastOtherDetailChangeEntity entity = service.selectById(id);
    	ForecastOtherDetailChangeVO vo = BeanMapper.map(entity, ForecastOtherDetailChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastOtherDetailChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ForecastOtherDetailChangeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ForecastOtherDetailChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ForecastOtherDetailChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ForecastOtherDetailChangeEntity> page = service.queryPage(param,false);
        IPage<ForecastOtherDetailChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastOtherDetailChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ForecastOtherDetailChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ForecastOtherDetailChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refForecastOtherDetailChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ForecastOtherDetailChangeVO>> refForecastOtherDetailChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ForecastOtherDetailChangeEntity> page = service.queryPage(param,false);
        IPage<ForecastOtherDetailChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastOtherDetailChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryOtherDetail", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> type(@RequestParam(value = "searchText", required = false) String searchText,
                                          @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("sourceForecastId");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        String sourceForecastId = null;
        String subjectName = null;
        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            sourceForecastId =  _con.getString("sourceForecastId");
            subjectName =  _con.getString("subjectName");

        }
//        List<ForecastOtherDetailChangeEntity> list = service.queryList(param,false);
        List<ForecastOtherDetailChangeEntity> list = this.baseMapper.queryall(sourceForecastId,subjectName);
        List<Long> ids = new ArrayList<>();
        if(list != null && list.size()>0){
            for(ForecastOtherDetailChangeEntity entity:list) {
            String isin = "N";
            Long sotid = entity.getSourceForecastOtherId();
            Long nid = entity.getId();
            if(sotid != null && nid != null && sotid != nid){
                if(ids != null && ids.size() >0){
                    for(Long iddata : ids){
                        if(iddata.equals(sotid)){
                            isin = "Y";
                            break;
                        }
                    }
                }
            }
            if(isin.equals("N")){
                map = new HashMap<>();
                map.put("id", entity.getId());
                map.put("sourceForecastOtherId", entity.getSourceForecastOtherId());
                map.put("sourceForecastId", entity.getSourceForecastId());
                map.put("costTypeId", entity.getCostTypeId());
                map.put("costTypeName", entity.getCostTypeName());
                map.put("costAnalysis", entity.getCostAnalysis());
                map.put("subjectId", entity.getSubjectId());
                map.put("subjectName", entity.getSubjectName());
                map.put("estimatedAmount", entity.getEstimatedAmount());
                map.put("estimatedTaxAmount", entity.getEstimatedTaxAmount());
                map.put("taxMny", entity.getTaxMny());
                ids.add(entity.getId());
                resultMapList.add(map);
            }

            }
        }

        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryAllOtherDetail", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> alltype(@RequestParam(value = "searchText", required = false) String searchText,
                                          @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("projectId");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            } else {
                throw new BusinessException("请先选择项目！");
            }
        } else {
            throw new BusinessException("请先选择项目！");
        }
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        String projectId = null;
//        projectId = "795327292791341101";
        String subjectName = null;
        Long contractId = null;
        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            projectId =  _con.getString("projectId");
            subjectName =  _con.getString("subjectName");
            contractId = _con.getLong("contractId");
        }
//        List<ForecastOtherDetailChangeEntity> list = service.queryList(param,false);
        List<ForecastOtherDetailChangeEntity> list = this.baseMapper.queryalldata(projectId,subjectName);
        List<Long> ids = new ArrayList<>();
        if(list != null && list.size()>0){
            for(ForecastOtherDetailChangeEntity entity:list) {
            String isin = "N";
            Long subjectid = entity.getSubjectId();
            if(ids != null && ids.size()>0){
                for(Long iddata : ids){
                    if(iddata.equals(subjectid)){
                        isin = "Y";
                        break;
                    }
                }
            }
            if(isin.equals("N")){
                //查询使用了本成本科目的其他费用合同和付款申请单
                BigDecimal sourcemoney = entity.getEstimatedTaxAmount();//含税金额
//                BigDecimal sourcemoneynotax = entity.getEstimatedAmount();//不含税金额

                BigDecimal htmoney = this.baseMapper.querycontractmoney(entity.getProjectId(),entity.getSubjectId(),contractId);

                BigDecimal contractAmountbc = this.baseMapper.querycontractAmountbc(entity.getProjectId(),entity.getSubjectId(),contractId);
//                BigDecimal htmoneynotax = this.baseMapper.querycontractmoneynotax(entity.getProjectId(),entity.getSubjectId(),contractId);

                BigDecimal jsmoney = this.baseMapper.querysetmoney(entity.getProjectId(),entity.getSubjectId());

                BigDecimal money = sourcemoney.subtract(htmoney).subtract(jsmoney).subtract(contractAmountbc);

                map = new HashMap<>();
                map.put("id", entity.getSubjectId());
                map.put("projectId",entity.getProjectId());
                map.put("costTypeId", entity.getCostTypeId());
                map.put("costTypeName", entity.getCostTypeName());
                map.put("costAnalysis", entity.getCostAnalysis());
                map.put("subjectId", entity.getSubjectId());
                map.put("name", entity.getSubjectName());
                map.put("estimatedAmount", money);
                map.put("estimatedTaxAmount", entity.getEstimatedTaxAmount());
                map.put("taxMny", entity.getTaxMny());
                ids.add(entity.getSubjectId());
                resultMapList.add(map);
            }
            }
        }

        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/querysubject", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refSubjectProjectData(@RequestParam(value = "searchText", required = false) String searchText,
                                                           @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("subjectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        if (StringUtils.isNotEmpty(condition)) {
//            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
//            if (null != conditionMap.get("projectId")) {
//                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
//                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//            } else {
//                throw new BusinessException("请先选择项目！");
//            }
//        } else {
//            throw new BusinessException("请先选择项目！");
//        }
        param.getOrderMap().put("subjectCode", "asc");
        String projectId = null;
        String subjectName = null;
        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getString("projectId");
            subjectName = _con.getString("subjectName");

        }

        projectId = "794566967620026456";

        Integer count = this.baseMapper.queryforecast(projectId);

        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        if(count == 0){
            List<SubjectProjectEntity> list = subjectProjectService.queryList(param, false);

            for(SubjectProjectEntity entity:list) {
                map = new HashMap<>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getSubjectName());
                map.put("code", entity.getSubjectCode());
                map.put("parentId", entity.getParentId());
                map.put("memo", entity.getMemo());
                map.put("orgSubjectId", entity.getOrgSubjectId());
                map.put("innerCode", entity.getInnerCode());
                resultMapList.add(map);
            }
        }else if(count == 1){
            List<ForecastOtherDetailChangeEntity> list = this.baseMapper.queryalldata(projectId,subjectName);
            List<Long> ids = new ArrayList<>();
            if(list != null && list.size()>0) {
                for (ForecastOtherDetailChangeEntity entity : list) {
                    String isin = "N";
                    Long subjectid = entity.getSubjectId();
                    if (ids != null && ids.size() > 0) {
                        for (Long iddata : ids) {
                            if (iddata.equals(subjectid)) {
                                isin = "Y";
                                break;
                            }
                        }
                    }
                    if (isin.equals("N")) {
                        //查询使用了本成本科目的其他费用合同和付款申请单
                        BigDecimal sourcemoney = entity.getEstimatedTaxAmount();//含税金额
//                BigDecimal sourcemoneynotax = entity.getEstimatedAmount();//不含税金额

                        Long contractId = null;

                        BigDecimal htmoney = this.baseMapper.querycontractmoney(entity.getProjectId(), entity.getSubjectId(), contractId);
//                BigDecimal htmoneynotax = this.baseMapper.querycontractmoneynotax(entity.getProjectId(),entity.getSubjectId(),contractId);

                        BigDecimal jsmoney = this.baseMapper.querysetmoney(entity.getProjectId(), entity.getSubjectId());

                        BigDecimal money = sourcemoney.subtract(htmoney).subtract(jsmoney);

                        map = new HashMap<>();
                        map.put("id", entity.getSubjectId());
                        map.put("projectId", entity.getProjectId());
                        map.put("costTypeId", entity.getCostTypeId());
                        map.put("costTypeName", entity.getCostTypeName());
                        map.put("costAnalysis", entity.getCostAnalysis());
                        map.put("subjectId", entity.getSubjectId());
                        map.put("name", entity.getSubjectName());
                        map.put("estimatedAmount", money);
                        map.put("estimatedTaxAmount", entity.getEstimatedTaxAmount());
                        map.put("taxMny", entity.getTaxMny());
                        ids.add(entity.getSubjectId());
                        resultMapList.add(map);
                    }
                }
            }
        }


        return ResultAsTree.createTreeData(resultMapList);
    }
}
