package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.bean.CostClosingChangesEntity;
import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.bean.ForecastContractDetailEntity;
import com.ejianc.business.cost.mapper.CostClosingLastMapper;
import com.ejianc.business.cost.service.ICostClosingChangesService;
import com.ejianc.business.cost.vo.CostClosingChangesVO;
import com.ejianc.business.cost.vo.CostClosingVO;
import com.ejianc.business.cost.vo.ForecastContractDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.CostClosingMapper;
import com.ejianc.business.cost.bean.CostClosingEntity;
import com.ejianc.business.cost.service.ICostClosingService;

import java.util.List;
import java.util.Map;

/**
 * 成本关门
 *
 * @author generator
 *
 */
@Service("costClosingService")
public class CostClosingServiceImpl extends BaseServiceImpl<CostClosingMapper, CostClosingEntity> implements ICostClosingService{
    @Autowired
    private ICostClosingChangesService costClosingChangesService;

    @Autowired
    private CostClosingLastMapper costClosingLastMapper;

    @Override
    public Map<String,Object> queryProjectPage(String id) {
        return this.baseMapper.queryProjectPage(id);
    }

    @Override
    public CostClosingVO queryDetailRecord(Long id) {
        CostClosingEntity costClosingEntity = this.baseMapper.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("clos_notice_id", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        List<CostClosingChangesEntity> purchaseDetailss = costClosingChangesService.queryList(queryParam, false);
        List<CostClosingChangesVO> costClosingChangesList = BeanMapper.mapList(purchaseDetailss, CostClosingChangesVO.class);
        CostClosingVO vo = BeanMapper.map(costClosingEntity, CostClosingVO.class);
        vo.setCostClosingChanges(costClosingChangesList);
        return vo;
    }

    @Override
    public String addProjectCheck(Long projectId,Long id) {
        String message = "";
        Integer total = this.baseMapper.querytotal(projectId,id);
        if(total != 0) {
            message ="该项目已经存在成本关门预估单！";
        }
        return message;
    }

    @Override
    public String checkchange(Long id) {
        String message = "";
        CostClosingEntity entity = this.selectById(id);
        Integer total = this.baseMapper.querychange(id);
        if(total != 0) {
            message ="当前选中通知单存在尚未提交或审核的变更单，请提交或审核后再进行变更！";
        }
        Integer sumtotal = costClosingLastMapper.querysum(entity.getProjectId());
        if(sumtotal != 0) {
            message ="当前选中最终通知单已完成最终成本关门汇总，禁止变更！";
        }
        return message;
    }
}
