/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.CostClosingForecastChangeEntity;
import com.ejianc.business.cost.bean.CostClosingForecastEntity;
import com.ejianc.business.cost.mapper.CostClosingForecastChangeMapper;
import com.ejianc.business.cost.service.ICostClosingForecastChangeService;
import com.ejianc.business.cost.service.ICostClosingForecastService;
import com.ejianc.business.cost.vo.CostClosingForecastChangeVO;
import com.ejianc.business.cost.vo.ForecastOtherDetailChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costClosingForecastChange"})
public class CostClosingForecastChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "COST_CLOSING_FORECAST_CHANGE";
    @Autowired
    private ICostClosingForecastChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CostClosingForecastChangeMapper baseMapper;
    @Autowired
    private ICostClosingForecastService costClosingForecastService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CostClosingForecastChangeVO> saveOrUpdate(@RequestBody CostClosingForecastChangeVO saveOrUpdateVO) {
        Long forecastId = saveOrUpdateVO.getSourceForecastId();
        Long id = saveOrUpdateVO.getId();
        Integer count = 0;
        count = id != null ? this.baseMapper.countClosing(forecastId, id) : this.baseMapper.countClosing1(forecastId);
        if (count != 0) {
            throw new BusinessException("\u5f53\u524d\u9884\u4f30\u5355\u4e0b\u5b58\u5728\u5c1a\u672a\u8fc7\u5ba1\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4fdd\u5b58");
        }
        List elist = saveOrUpdateVO.getForecastOtherDetailChangeList();
        if (elist != null && elist.size() > 0) {
            for (ForecastOtherDetailChangeVO vo : elist) {
                Long costtype = vo.getCostTypeId();
                Long subjectId = vo.getSubjectId();
                Integer countchange = this.baseMapper.querysub(costtype, subjectId, id);
                Integer countsource = this.baseMapper.querysubsour(costtype, subjectId, id);
                String subjectname = this.baseMapper.querysubname(subjectId);
                if (countchange == 0 && countsource == 0) continue;
                throw new BusinessException("\u6210\u672c\u79d1\u76ee " + subjectname + " \u5df2\u5728\u8be5\u9879\u76ee\u4e0b\u5c5e\u6210\u672c\u5173\u95e8\u9884\u4f30\u5355\u636e\u4e2d\u9009\u53d6\u8fc7\uff0c\u7981\u6b62\u4fdd\u5b58\uff01");
            }
        }
        CommonResponse<CostClosingForecastChangeVO> response = this.service.insertOrUpdate(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostClosingForecastChangeVO> queryDetail(Long id) {
        CostClosingForecastChangeEntity entity = (CostClosingForecastChangeEntity)((Object)this.baseMapper.selectById(id));
        CostClosingForecastChangeVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCostClosingForecast"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CostClosingForecastChangeVO> queryCostClosingForecast(Long id) {
        CostClosingForecastChangeVO vo = this.service.queryCostClosingForecast(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostClosingForecastChangeVO> vos) {
        Long id = vos.get(0).getId();
        CostClosingForecastChangeEntity vo = (CostClosingForecastChangeEntity)((Object)this.service.selectById(id));
        this.service.deleteDatas(vos);
        Integer total = this.baseMapper.querychangetotal(vo.getSourceForecastId());
        if (total == 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(CostClosingForecastEntity::getChangeStatus, (Object)Character.valueOf('1'));
            updateWrapper.set(CostClosingForecastEntity::getChangeStatusName, (Object)"\u672a\u53d8\u66f4");
            updateWrapper.eq(BaseEntity::getId, (Object)vo.getSourceForecastId());
            this.costClosingForecastService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CostClosingForecastChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostClosingForecastChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CostClosingForecastChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCostClosingForecastChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CostClosingForecastChangeVO>> refCostClosingForecastChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CostClosingForecastChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

