/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.ForecastContractDetailChangeEntity;
import com.ejianc.business.cost.mapper.ForecastContractDetailChangeMapper;
import com.ejianc.business.cost.service.IForecastContractDetailChangeService;
import com.ejianc.business.cost.service.IForecastContractDetailService;
import com.ejianc.business.cost.vo.ForecastChangeMachinecontractDetailVO;
import com.ejianc.business.cost.vo.ForecastChangeMaterialcontractDetailVO;
import com.ejianc.business.cost.vo.ForecastChangeOthercontractDetailVO;
import com.ejianc.business.cost.vo.ForecastContractDetailChangeVO;
import com.ejianc.business.cost.vo.ForecastContractDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"forecastContractDetailChange"})
public class ForecastContractDetailChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IForecastContractDetailChangeService service;
    @Autowired
    private IForecastContractDetailService iForecastContractDetailService;
    @Autowired
    private ForecastContractDetailChangeMapper forecastContractDetailChangeMapper;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ForecastContractDetailChangeVO> saveOrUpdate(@RequestBody ForecastContractDetailChangeVO saveOrUpdateVO) {
        ForecastContractDetailChangeEntity entity = (ForecastContractDetailChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ForecastContractDetailChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ForecastContractDetailChangeVO vo = (ForecastContractDetailChangeVO)BeanMapper.map((Object)((Object)entity), ForecastContractDetailChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ForecastContractDetailChangeVO> queryDetail(Long id) {
        ForecastContractDetailChangeEntity entity = (ForecastContractDetailChangeEntity)((Object)this.service.selectById(id));
        ForecastContractDetailChangeVO vo = (ForecastContractDetailChangeVO)BeanMapper.map((Object)((Object)entity), ForecastContractDetailChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastContractDetailChangeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ForecastContractDetailChangeVO forecastContractDetailChangeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ForecastContractDetailChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastContractDetailChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ForecastContractDetailChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refForecastContractDetailChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ForecastContractDetailChangeVO>> refForecastContractDetailChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastContractDetailChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySubContractByProjectIdMaterial"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ForecastChangeMaterialcontractDetailVO>> refProjectDataMaterial(@RequestParam(value="projectId", required=false) String projectId) {
        List<ForecastChangeMaterialcontractDetailVO> resultList = this.service.querySubContractByProjectIdMaterial(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    @RequestMapping(value={"/querySubContractByProjectIdMachine"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ForecastChangeMachinecontractDetailVO>> refProjectDataMachine(@RequestParam(value="projectId", required=false) String projectId) {
        List<ForecastChangeMachinecontractDetailVO> resultList = this.service.querySubContractByProjectIdMachine(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    @RequestMapping(value={"/querySubContractByProjectIdOther"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ForecastChangeOthercontractDetailVO>> refProjectDataOther(@RequestParam(value="projectId", required=false) String projectId) {
        List<ForecastChangeOthercontractDetailVO> resultList = this.service.querySubContractByProjectIdOther(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    @RequestMapping(value={"/querySubContractByIdMaterial"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ForecastChangeMaterialcontractDetailVO>> refProjectDataMaterial(@RequestParam(value="id", required=false) Long id) {
        List<ForecastChangeMaterialcontractDetailVO> resultList = this.service.querySubContractByIdMaterial(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    @RequestMapping(value={"/querySubContractByIdMachine"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ForecastChangeMachinecontractDetailVO>> refProjectDataMachine(@RequestParam(value="id", required=false) Long id) {
        List<ForecastChangeMachinecontractDetailVO> resultList = this.service.querySubContractByIdMachine(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    @RequestMapping(value={"/querySubContractByIdOther"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ForecastChangeOthercontractDetailVO>> refProjectDataOther(@RequestParam(value="id", required=false) Long id) {
        List<ForecastChangeOthercontractDetailVO> resultList = this.service.querySubContractByIdOther(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    @RequestMapping(value={"/queryAllSubDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ForecastContractDetailVO>> queryAllSubDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractType");
        fuzzyFields.add("subOrg");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            this.logger.debug("condition is " + condition);
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("costClosingForecastId")) {
                Long costClosingForecastId = Long.valueOf(conditionMap.get("costClosingForecastId").toString());
                param.getParams().put("costClosingForecastId", new Parameter("eq", (Object)costClosingForecastId));
            }
        }
        IPage page = this.iForecastContractDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastContractDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

