/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.bean.CostClosingLastChangeEntity;
import com.ejianc.business.cost.bean.CostClosingLastEntity;
import com.ejianc.business.cost.mapper.CostClosingLastChangeMapper;
import com.ejianc.business.cost.mapper.CostClosingLastMapper;
import com.ejianc.business.cost.service.ICostClosingLastChangeService;
import com.ejianc.business.cost.service.ICostClosingLastService;
import com.ejianc.business.cost.vo.CostClosingLastChangeVO;
import com.ejianc.business.cost.vo.CostClosingLastVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costClosingLastChangeService")
public class CostClosingLastChangeServiceImpl
extends BaseServiceImpl<CostClosingLastChangeMapper, CostClosingLastChangeEntity>
implements ICostClosingLastChangeService {
    private static final String BILL_CODE_ROLE = "COST_CLOSING_LAST_CHANGE";
    @Autowired
    private CostClosingLastMapper costClosingLastMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private CostClosingLastChangeMapper costClosingLastChangeMapper;
    @Autowired
    private ICostClosingLastService costClosingLastService;

    @Override
    public CostClosingLastChangeVO queryDetailChange(Long id) {
        CostClosingLastEntity costClosingLastEntity = (CostClosingLastEntity)((Object)this.costClosingLastMapper.selectById(id));
        if (!ObjectUtil.isEmpty((Object)((Object)costClosingLastEntity))) {
            CostClosingLastChangeVO contractVo = (CostClosingLastChangeVO)BeanMapper.map((Object)((Object)costClosingLastEntity), CostClosingLastChangeVO.class);
            contractVo.setOldlastCostClosingTime(costClosingLastEntity.getLastCostClosingTime());
            contractVo.setLastCostClosingTime(costClosingLastEntity.getLastCostClosingTime());
            contractVo.setClosingLastId(costClosingLastEntity.getId());
            contractVo.setId(null);
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setMemo(null);
            contractVo.setDays("0");
            return contractVo;
        }
        return null;
    }

    @Override
    public CommonResponse<CostClosingLastChangeVO> saveOrUpdate(CostClosingLastChangeVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CostClosingLastChangeEntity entity = null;
        String operateType = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
                saveOrUpdateVO.setBillCode(null);
            }
            entity = (CostClosingLastChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CostClosingLastChangeEntity.class));
            operateType = "edit";
        } else {
            if (null == saveOrUpdateVO.getChangeVersion() || saveOrUpdateVO.getChangeVersion() == 0) {
                saveOrUpdateVO.setChangeVersion(Integer.valueOf(1));
            } else {
                saveOrUpdateVO.setChangeVersion(Integer.valueOf(saveOrUpdateVO.getChangeVersion() + 1));
            }
            if (2 == saveOrUpdateVO.getChangeStatus()) {
                throw new BusinessException("\u6210\u672c\u5173\u95e8\u901a\u77e5\u5355\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (CostClosingLastChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CostClosingLastChangeEntity.class));
            operateType = "add";
        }
        super.saveOrUpdate((Object)entity);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        Long sourceId = entity.getClosingLastId();
        CostClosingLastEntity source = (CostClosingLastEntity)((Object)this.costClosingLastService.selectById(sourceId));
        Date oldtime = source.getOldCostClosingTime();
        if (oldtime == null) {
            updateWrapper.set(CostClosingLastEntity::getOldCostClosingTime, (Object)entity.getOldlastCostClosingTime());
        }
        updateWrapper.set(CostClosingLastEntity::getLastCostClosingTime, (Object)saveOrUpdateVO.getLastCostClosingTime());
        updateWrapper.set(CostClosingLastEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(CostClosingLastEntity::getDays, (Object)saveOrUpdateVO.getDays());
        updateWrapper.set(CostClosingLastEntity::getChangeStatus, (Object)3);
        updateWrapper.set(CostClosingLastEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getClosingLastId());
        this.costClosingLastService.update((Wrapper)updateWrapper);
        CostClosingLastChangeEntity costClosingLastChangeEntity = (CostClosingLastChangeEntity)((Object)super.selectById((Serializable)entity.getId()));
        CostClosingLastChangeVO vo = (CostClosingLastChangeVO)BeanMapper.map((Object)((Object)costClosingLastChangeEntity), CostClosingLastChangeVO.class);
        return CommonResponse.success((Object)vo);
    }

    @Override
    public CostClosingLastVO queryDetailRecord(Long id) {
        CostClosingLastEntity costClosingLastEntity = (CostClosingLastEntity)((Object)this.costClosingLastMapper.selectById(id));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("closing_last_id", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("create_time", "desc");
        List purchaseDetailss = super.queryList(queryParam, false);
        List costClosingChangesList = BeanMapper.mapList((Iterable)purchaseDetailss, CostClosingLastChangeVO.class);
        CostClosingLastVO vo = (CostClosingLastVO)BeanMapper.map((Object)((Object)costClosingLastEntity), CostClosingLastVO.class);
        vo.setCostClosingChanges(costClosingChangesList);
        return vo;
    }

    @Override
    public BigDecimal selectAmountNotaxByProjectId(Long projectId) {
        BigDecimal amount = ((CostClosingLastChangeMapper)this.baseMapper).notax(projectId);
        return amount;
    }

    @Override
    public Integer countByProject(Long projectId) {
        Integer count = ((CostClosingLastChangeMapper)this.baseMapper).countByProject(projectId);
        return count;
    }
}

