package com.ejianc.business.sub.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.ParamUtil;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.HttpTookit;
import com.ejianc.business.sub.vo.SettleRecordVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包过程结算表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("settle")
public class SettleController implements Serializable {

    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Autowired
    private ISettleService settleService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;

    /**
     *   * 查看凭证  * @Param id: 主键  * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.sub.vo.SettleVO>  * @Author songlx  * @Date 2021-04-28
     **/
    @RequestMapping(value = "/viewVoucher", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> viewVoucher(Long id) {
        Map<String, String> headers = new HashMap<>();
        JSONObject jsonObject = new JSONObject();

        /***
         method : 'queryVoucher',
         pkValue : '440160314430062650',
         key: 'pk_subdeduct',
         table: 'jzsub_subrewarddeduct'
         */
        jsonObject.put("key", "pk_subdeduct");
        jsonObject.put("table", "jzsub_subrewarddeduct");
        jsonObject.put("method", "queryVoucher");
        jsonObject.put("pkValue", String.valueOf(id));
        try {
            String postByJson = HttpTookit.postByJson("http://47.94.227.96:8010/servlet/MobileBillServlet", jsonObject.toString(), headers);
            String resultStr = new String(postByJson.getBytes("ISO-8859-1"), "UTF-8");
            JSONObject json = JSONObject.parseObject(resultStr);
            Integer errorCode = json.getInteger("error_code");
            String errorMessage = json.getString("error_msg");
            if(errorCode == null){
                return CommonResponse.error("NC传递过来的数据中没有error_code！");
            }
            else if(errorCode == 200){
                return CommonResponse.success("查询凭证成功！", json);
            }else{
                return CommonResponse.error(errorMessage);

            }


        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return CommonResponse.error("查询凭证失败！");

    }


    /**
     * @param settleVO
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO settleVO) {
        SettleVO vo = settleService.insertOrUpdate(settleVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleVO vo = settleService.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SettleEntity> pageData = settleService.queryPage(param, false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), SettleVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        return settleService.deleteByIds(vos);
    }

    /**
     * @param id
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailRecord 查询记录
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleRecordVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleRecordVO> queryDetailRecord(Long id) {
        SettleRecordVO vo = settleService.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param contractId
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增查询合同转化为过程结算
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/queryDetailAdd", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetailAdd(Long contractId) {
        SettleVO vo = settleService.queryDetailAdd(contractId);
        return CommonResponse.success("新增查询合同转化为过程结算成功！", vo);
    }

    /**
     * 根据主键ID,orgId查询累计结算金额，累计冲抵金额,累计付款，累计预付款金额
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/querySumSettlementTaxMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> querySumSettlementTaxMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        SettleVO vo = new SettleVO();
        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(contractId, orgId);
        if (!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        vo.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper<SettleEntity> lambdachange = Wrappers.<SettleEntity>lambdaQuery();
        lambdachange.eq(SettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(SettleEntity::getContractId, contractId);
        lambdachange.eq(SettleEntity::getOrgId, orgId);
        lambdachange.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettleEntity> list = settleService.list(lambdachange);
        if (CollectionUtils.isNotEmpty(list)) {
            final BigDecimal[] alreadySettleMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP), new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e -> {
                alreadySettleMoney[0] = alreadySettleMoney[0].add(e.getSettleTaxMny() == null ? BigDecimal.ZERO : e.getSettleTaxMny());
                alreadySettleMoney[1] = alreadySettleMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            //累计结算金额
            vo.setSumSettleTaxMny(alreadySettleMoney[0]);
            //累计冲抵金额
            vo.setSumOffsetMny(alreadySettleMoney[1]);
        }
        BigDecimal sumOffsetMnys = vo.getSumOffsetMny() == null ? BigDecimal.ZERO : vo.getSumOffsetMny();
        if (vo.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }

        return CommonResponse.success(vo);
    }

    /**
     * @Author yqls
     * @Date 2020/7/9 分包结算参照
     * @Description purchaseSettlementRef
     * @Param [pageNumber, pageSize, condition, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.material.vo.PurchaseSettlementVO>>
     */
    @RequestMapping(value = "/subSettlementRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> subSettlementRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null == conditionMap.get("type") || !"settleReport".equals(conditionMap.get("type"))) {
                /** 剩余可申请金额不等于0  */
                ComplexParam c4 = ParamUtil.getOrParam("surplusApplyMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
                queryParam.getComplexParams().add(c4);
            }
        }

//        ComplexParam c5 = ParamUtil.getOrParam("shouldPayTaxMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
//        queryParam.getComplexParams().add(c5);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        if (StringUtils.isNotBlank(condition)) {
            JSONObject con = JSONObject.parseObject(condition);
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, con.getLong("contractId")));
            }
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, con.getLong("orgId")));
            }
            if (condition.contains("supplierId")) {
                queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, con.getLong("supplierId")));
            }
        }
        JSONObject page = settleService.querySubSettleVOList(queryParam, false);
        return CommonResponse.success("参照查询成功！", page);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<SettleEntity> pageData = settleService.queryPage(param, false);
        List<SettleVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), SettleVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    /**
     * @param settleVO
     * @Author zhangwx
     * @Date 2020/12/24
     * @Description pushCost关联保存
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO settleVO) {
        return settleService.pushCost(settleVO);
    }

    /**
     * @param contractId contractId
     * @Author zhangwx
     * @Date 2020/12/24
     * @Description pushCost关联保存
     * @Return com.ejianc.framework.core.response.CommonResponse<SettleVO>
     */
    @RequestMapping(value = "/pushNc", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushNc(@RequestParam Long id) {
        return settleService.pushNc(id);
    }
}
