package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.HttpTookit;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 过程结算表 审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("settle")
public class SettleBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IOddjobService oddjobService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
        SettleEntity settlementEntity= settleService.selectById(billId);
        BigDecimal offsetMny = settlementEntity.getOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getOffsetMny();//本次冲抵金额
        BigDecimal sumPayMnys = settlementEntity.getSumPrepayMny()==null?BigDecimal.ZERO:settlementEntity.getSumPrepayMny();//实际预付款金额
        BigDecimal sumOffsetMnys = settlementEntity.getSumOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getSumOffsetMny();//实际累计冲抵金额
        if(offsetMny.compareTo(sumPayMnys.subtract(sumOffsetMnys))>0){
            return CommonResponse.error("审批回写异常!该合同冲抵金额已超出预付款金额!");
        }

        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleVO settleEntity = settleService.queryDetail(billId, true);
        ContractEntity contractEntity  = contractService.getById(settleEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();

        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny()==null?BigDecimal.ZERO:settleEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny()==null?BigDecimal.ZERO:settleEntity.getOffsetMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.add(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.add(otherMny));
        updateWrapper.set(ContractEntity::getSumOffsetMny, sumOffsetMny.add(offsetMny));
        updateWrapper.eq(ContractEntity::getId, settleEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(settleEntity.getSettleOddjobList())){
//            oddjobService.updateSettleByPks(settleEntity.getSettleOddjobList().stream().map(SettleOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.TRUE);
//        }
        if(CollectionUtils.isNotEmpty(settleEntity.getSettleOddjobList())){
            oddjobService.updateSettleMnyByPks(settleEntity.getSettleOddjobList(), Boolean.TRUE);
        }

        settleService.costPush(BeanMapper.map(settleEntity, SettleEntity.class));

        pushToNC(settleEntity);

        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        SettleEntity settlementEntity = settleService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(settlementEntity.getContractId());
        //如果合同完工结算,不允许弃审
        if (contractEntity.getFinishFlag()){
            return CommonResponse.error("该合同已经完工结算，不能回退!");
        }
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            LambdaQueryWrapper<SettleEntity> lambdachange = Wrappers.<SettleEntity>lambdaQuery();
            lambdachange.eq(SettleEntity::getContractId, settlementEntity.getContractId());
            lambdachange.eq(SettleEntity::getOrgId, settlementEntity.getOrgId());
            lambdachange.gt(SettleEntity::getCreateTime, settlementEntity.getCreateTime());
            lambdachange.ne(SettleEntity::getId,billId);
            lambdachange.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = settleService.count(lambdachange);
            if (num > 0) {
                return CommonResponse.error("审批回写异常!该合同不是最新的结算日期，不能回退!");
            } else {
                return CommonResponse.success();
            }
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        SettleVO settleEntity = settleService.queryDetail(billId, true);
        ContractEntity contractEntity  = contractService.getById(settleEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = settleEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settleEntity.getSettleTaxMny();
        BigDecimal settleMny = settleEntity.getSettleMny() == null ? BigDecimal.ZERO : settleEntity.getSettleMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = settleEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobTaxMny();
        BigDecimal jobMny = settleEntity.getOddjobMny() == null ? BigDecimal.ZERO : settleEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = settleEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : settleEntity.getOtherTaxMny();
        BigDecimal otherMny = settleEntity.getOtherMny() == null ? BigDecimal.ZERO : settleEntity.getOtherMny();

        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny()==null?BigDecimal.ZERO:settleEntity.getSumOffsetMny();
        BigDecimal offsetMny = settleEntity.getOffsetMny()==null?BigDecimal.ZERO:settleEntity.getOffsetMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.subtract(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.subtract(otherMny));
        updateWrapper.set(ContractEntity::getSumOffsetMny, sumOffsetMny.subtract(offsetMny));
        updateWrapper.eq(ContractEntity::getId, settleEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(settleEntity.getSettleOddjobList())){
//            oddjobService.updateSettleByPks(settleEntity.getSettleOddjobList().stream().map(SettleOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.FALSE);
//        }
        if(CollectionUtils.isNotEmpty(settleEntity.getSettleOddjobList())){
            oddjobService.updateSettleMnyByPks(settleEntity.getSettleOddjobList(), Boolean.FALSE);
        }

        settleService.pullCost(billId);

        return CommonResponse.success("审批回调合同成功！");
    }

    private void pushToNC(SettleVO settleVO){
        Map<String, String> headers = new HashMap<>();
        MidVO midVO = new MidVO();
        midVO.setNdeductoriginmny(settleVO.getSettleTaxMny().intValue());
        midVO.setNedeductorigintaxmny(settleVO.getSettleTaxMny().intValue());
        midVO.setVdef1(settleVO.getId().toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("method", "subBillSave");
        jsonObject.put("headdata", JSONObject.toJSON(midVO));
        try {
            HttpTookit.postByJson("http://47.94.227.96:8010/servlet/MobileBillServlet", jsonObject.toString(), headers);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    class MidVO{
        private Integer ndeductoriginmny;
        private Integer nedeductorigintaxmny;
        private String vdef1;

        public Integer getNdeductoriginmny() {
            return ndeductoriginmny;
        }

        public void setNdeductoriginmny(Integer ndeductoriginmny) {
            this.ndeductoriginmny = ndeductoriginmny;
        }

        public Integer getNedeductorigintaxmny() {
            return nedeductorigintaxmny;
        }

        public void setNedeductorigintaxmny(Integer nedeductorigintaxmny) {
            this.nedeductorigintaxmny = nedeductorigintaxmny;
        }

        public String getVdef1() {
            return vdef1;
        }

        public void setVdef1(String vdef1) {
            this.vdef1 = vdef1;
        }
    }
}
