package com.ejianc.certify.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @description  证照状态枚举类
 * @author yxm
 */
public enum CertStatusEnum {
    INVALID(0, "未生效"),
    VALID(1, "生效"),
    LAPSE(2, "失效");

    private Integer code;
    private String desc;

    private static Map<Integer,CertStatusEnum> codeMap = new HashMap<>();
    private static Map<String,CertStatusEnum> descMap = new HashMap<>();

    static {
        for (CertStatusEnum value : CertStatusEnum.values()) {
            codeMap.put(value.getCode(),value);
            descMap.put(value.getDesc(),value);
        }
    }

    private CertStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code查找
     * @param code 枚举code
     * @return 枚举对象
     */
    public static String findDesc(Integer code) {
        String desc = codeMap.get(code).getDesc();
        if (StringUtils.isNotBlank(desc)) {
            return desc;
        }else{
            throw new IllegalArgumentException("没有找到对应的证照状态,请检查数据是否正确");
        }
    }

    /**
     * 根据desc查找
     * @param desc 枚举desc
     * @return 枚举对象
     */
    public static Integer findCode(String desc) {
        Integer code = descMap.get(desc).getCode();
        if (Optional.of(code).isPresent()) {
            return code;
        }else{
            throw new IllegalArgumentException("没有找到对应的证照状态,请检查数据是否正确");
        }
    }
}
