package com.ejianc.certify.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author yxm
 * @date 2022/5/17
 * @description 是否枚举
 */
public enum YesNoEnum {
    YES("0","是"),
    NO("1","否");

    private String code;
    private String desc;

    private static Map<String,YesNoEnum> codeMap = new HashMap<>();
    private static Map<String,YesNoEnum> descMap = new HashMap<>();

    static {
        for (YesNoEnum value : YesNoEnum.values()) {
            codeMap.put(value.getCode(),value);
            descMap.put(value.getDesc(),value);
        }
    }


    private YesNoEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code查找
     * @param code 枚举code
     * @return 枚举对象
     */
    public static String findDesc(String code) {
        String desc = codeMap.get(code).getDesc();
        if (StringUtils.isNotBlank(desc)) {
            return desc;
        }else{
            throw new IllegalArgumentException("没有找到对应的是否状态,请检查数据是否正确");
        }
    }

    /**
     * 根据desc查找
     * @param desc 枚举desc
     * @return 枚举对象
     */
    public static String findCode(String desc) {
        String code = descMap.get(desc).getCode();
        if (Optional.of(code).isPresent()) {
            return code;
        }else{
            throw new IllegalArgumentException("没有找到对应的是否状态,请检查数据是否正确");
        }
    }
}
