package com.ejianc.certify.utils;

import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author yxm
 * @date 2022/6/8
 * @description 易启联权限相关工具类
 */
@Component
public class AuthUtil {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;

    @Autowired
    private SessionManager sessionManager;

    private static  AuthUtil authUtil;

    @PostConstruct
    public void init(){
        authUtil = this;
        authUtil.iEmplApi = this.iEmplApi;
        authUtil.iOrgApi = this.iOrgApi;
        authUtil.sessionManager = this.sessionManager;
    }

    /**
     * @description  获取当前用户的本下组织和部门权限
     * @author yxm
     * @date 2022/6/8
     */
    public static Map<String, List<Long>> getOrgAndDeptAuths(){
        Map<String,List<Long>> result = new HashMap<>();
        UserContext userContextCache = authUtil.sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            List<Long> ids = Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            CommonResponse<List<OrgVO>> childsResp = authUtil.iOrgApi.findChildrenByParentIds(ids);
            orgVOList = (List<OrgVO>) RpcUtil.getRespData(childsResp, false, "获取当前本下组织信息失败:",childsResp.getMsg());
        } else {//pc端查询
            CommonResponse<List<OrgVO>> childsResp = authUtil.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            orgVOList = (List<OrgVO>) RpcUtil.getRespData(childsResp, false, "获取当前本下组织信息失败:",childsResp.getMsg());
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            result.put("pkOrg", commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有pkDept字段，保存单据所属项目部 */
            result.put("pkDept", departmentIds);
        }
        return result;
    }

    /**
     * @description  获取当前用户的本下组织权限
     * @author yxm
     * @date 2022/6/8
     * @param
     */
    public static List<Long> getOrgAuths(){
        UserContext userContextCache = authUtil.sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            List<Long> ids = Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            CommonResponse<List<OrgVO>> childsResp = authUtil.iOrgApi.findChildrenByParentIds(ids);
            orgVOList = (List<OrgVO>) RpcUtil.getRespData(childsResp, false, "获取当前本下组织信息失败:",childsResp.getMsg());
        } else {//pc端查询
            CommonResponse<List<OrgVO>> childsResp = authUtil.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            orgVOList = (List<OrgVO>) RpcUtil.getRespData(childsResp, false, "获取当前本下组织信息失败:",childsResp.getMsg());
        }
        //普通组织 id
        List<Long> commonOrgIds = orgVOList.stream().filter(org -> org.getOrgType() != 5)
                                            .map(OrgVO::getId).collect(Collectors.toList());
        return commonOrgIds;
    }
}
