package com.ejianc.certify.enums;

/**
 * @description  证照状态枚举类
 * @author yxm
 */
public enum CertStatusEnum {
    INVALID(0, "未生效"),
    VALID(1, "已生效"),
    LAPSE(2, "失效");

    private Integer code;
    private String desc;

    private CertStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code查找
     * @param code 枚举code
     * @return 枚举对象
     */
    public static String findDescByCode(Integer code) {
        for (CertStatusEnum statusEnum : CertStatusEnum.values()) {
            if (statusEnum.getCode() == code) {
                return statusEnum.getDesc();
            }
        }
        throw new IllegalArgumentException("code is invalid");
    }

    /**
     * 根据desc查找
     * @param desc 枚举desc
     * @return 枚举对象
     */
    public static Integer findCodeByName(String desc) {
        for (CertStatusEnum statusEnum : CertStatusEnum.values()) {
            if (statusEnum.getDesc().equals(desc)) {
                return statusEnum.getCode();
            }
        }
        throw new IllegalArgumentException("desc is invalid");
    }
}
