package com.ejianc.certify.enums;

/**
 * @description  单据状态枚举类
 * @author yxm
 * @date 2022/5/18
 */
public enum FstatusEnum {
    FREE(1,"自由态"),
    AUDIT(2,"审批中"),
    CHECK(3,"审核通过"),
    REJECT(4,"审批不通过"),
    ;


    private Integer code;
    private String desc;

    private FstatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code查找
     * @param code 枚举code
     * @return 枚举对象
     */
    public static String findDescByCode(Integer code) {
        for (FstatusEnum statusEnum : FstatusEnum.values()) {
            if (statusEnum.getCode() == code) {
                return statusEnum.getDesc();
            }
        }
        throw new IllegalArgumentException("code is invalid");
    }

    /**
     * 根据desc查找
     * @param desc 枚举desc
     * @return 枚举对象
     */
    public static Integer findCodeByName(String desc) {
        for (FstatusEnum statusEnum : FstatusEnum.values()) {
            if (statusEnum.getDesc().equals(desc)) {
                return statusEnum.getCode();
            }
        }
        throw new IllegalArgumentException("desc is invalid");
    }
}
