package com.ejianc.certify.enums;

/**
 * @author yxm
 * @date 2022/5/17
 * @description 是否枚举
 */
public enum YesNoEnum {
    YES("0","是"),
    NO("1","否");

    private String code;
    private String desc;

    private YesNoEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code查找
     * @param code 枚举code
     * @return 枚举对象
     */
    public static String findDescByCode(String code) {
        for (YesNoEnum yesNoEnum : YesNoEnum.values()) {
            if (yesNoEnum.getCode().equals(code)) {
                return yesNoEnum.getDesc();
            }
        }
        throw new IllegalArgumentException("code is invalid");
    }

    /**
     * 根据desc查找
     * @param desc 枚举desc
     * @return 枚举对象
     */
    public static String findCodeByName(String desc) {
        for (YesNoEnum yesNoEnum : YesNoEnum.values()) {
            if (yesNoEnum.getDesc().equals(desc)) {
                return yesNoEnum.getCode();
            }
        }
        throw new IllegalArgumentException("desc is invalid");
    }
}
