package com.ejianc.certify.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.certify.vo.SocialInsuranceVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.certify.bean.SocialInsuranceEntity;

import java.util.List;

/**
 * 社保档案
 *
 * @author generator
 */
public interface ISocialInsuranceService extends IBaseService<SocialInsuranceEntity> {

    /**
     * 导入时需要进行判断，同一个人同一月份只能存在一条记录，存在相同记录则修改覆盖
     *
     * @param cardId
     * @param sbMonth
     * @return
     */
    SocialInsuranceVO getSocialInsuranceVoByCardId(String cardId, String sbMonth);

    /**
     * @description 根据员工ID获取最新社保主体相关信息
     * @author yxm
     * @date 2022/5/12
     */
    CommonResponse<SocialInsuranceVO> getSubInfoByEmplID(Long pkPsnid);

    /**
     * @description  获取社保主体参照信息
     * @author yxm
     * @date 2022/5/17
     */
    CommonResponse<IPage<DefdocDetailVO>> refSocialSubjectData(String condition, String searchObject, String searchText);

    /**
     * @description  根据社保主体名称获取社保主体ID
     * @author yxm
     * @date 2022/5/17
     */
    Long getSubIdByName(String name);
}
