/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.certify.bean.CertifTypeEntity;
import com.ejianc.certify.bean.CertifyTransferEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.mapper.CertifyTransferMapper;
import com.ejianc.certify.service.ICertifTypeService;
import com.ejianc.certify.service.ICertifyTransferService;
import com.ejianc.certify.vo.CertifyTransferVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="certifyTransferService")
public class CertifyTransferServiceImpl
extends BaseServiceImpl<CertifyTransferMapper, CertifyTransferEntity>
implements ICertifyTransferService {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Autowired
    private ICertifTypeService tservice;

    private void checkRespData(CommonResponse<?> resp, boolean isMustSuc, String title, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? title + errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        if (Objects.isNull(resp.getData())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof List && ListUtil.isEmpty((List)((List)resp.getData()))) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof IPage && ListUtil.isEmpty((List)((IPage)resp.getData()).getRecords())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("pkOrg", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, CertifyTransferVO.class);
        return this.exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifyTransferVO> vos) {
        for (CertifyTransferVO vo : vos) {
            CommonResponse certpsn = this.iEmplApi.getById(vo.getPkCertpsn());
            this.checkRespData(certpsn, true, "\u67e5\u8be2\u6301\u8bc1\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", certpsn.getMsg());
            vo.setPkCertpsnName(((EmployeeVO)certpsn.getData()).getName());
            CommonResponse org = this.iOrgApi.getOneById(vo.getPkOrg());
            this.checkRespData(org, true, "\u67e5\u8be2\u539f\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", org.getMsg());
            vo.setPkOrgName(((OrgVO)org.getData()).getName());
            CommonResponse pkDrorg = this.iOrgApi.getOneById(vo.getPkDrorg());
            this.checkRespData(pkDrorg, true, "\u67e5\u8be2\u8c03\u5165\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", pkDrorg.getMsg());
            vo.setPkDrorgName(((OrgVO)pkDrorg.getData()).getName());
            String certStatus = Optional.ofNullable(vo.getCertStatus()).orElse("0");
            vo.setCertStatusName(CertStatusEnum.findDesc((String)certStatus));
            CertifTypeEntity certifTypeEntity = (CertifTypeEntity)((Object)this.tservice.selectById(vo.getPkCertiftype()));
            Optional.ofNullable(certifTypeEntity).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));
            CommonResponse applyer = this.iEmplApi.getById(vo.getApplyer());
            this.checkRespData(applyer, true, "\u67e5\u8be2\u8c03\u51fa\u53d1\u8d77\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", applyer.getMsg());
            vo.setApplyerName(((EmployeeVO)applyer.getData()).getName());
            CommonResponse applyerorg = this.iOrgApi.getOneById(vo.getApplyerorg());
            this.checkRespData(applyerorg, true, "\u67e5\u8be2\u8c03\u51fa\u53d1\u8d77\u4eba\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", applyerorg.getMsg());
            vo.setApplyerorgName(((OrgVO)applyerorg.getData()).getName());
            Optional.ofNullable(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getBillState()).ifPresent(t -> vo.setBillStateName(BillStatusEnum.getDesc((Integer)t)));
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", vos);
        return beans;
    }
}

