/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifyregHEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.mapper.CertifyregHMapper;
import com.ejianc.certify.service.ICertifTypeService;
import com.ejianc.certify.service.ICertifregBService;
import com.ejianc.certify.service.ICertifregFService;
import com.ejianc.certify.service.ICertifySpecialReqService;
import com.ejianc.certify.service.ICertifyregHService;
import com.ejianc.certify.service.ISocialInsuranceService;
import com.ejianc.certify.utils.BarCodeUtils;
import com.ejianc.certify.vo.CertifregBVO;
import com.ejianc.certify.vo.CertifregFVO;
import com.ejianc.certify.vo.CertifySpecialReqBVO;
import com.ejianc.certify.vo.CertifyregHVO;
import com.ejianc.certify.vo.SocialInsuranceVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

@Service(value="certifyregHService")
public class CertifyregHServiceImpl
extends BaseServiceImpl<CertifyregHMapper, CertifyregHEntity>
implements ICertifyregHService {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Resource
    private IDefdocApi defdocApi;
    @Resource
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICertifregBService bService;
    @Autowired
    private ICertifregFService fService;
    @Autowired
    private ICertifTypeService tservice;
    @Autowired
    private ISocialInsuranceService sservice;
    @Autowired
    private ICertifySpecialReqService sreqService;
    @Autowired
    private CertifyregHMapper mapper;
    private static final String PKBILLTYPE = "ZJ001";
    private static final String EMPL_CODE_PREFIX = "EMP";
    private static final String TYPEATTRIBUTE_CODE = "GTZZ-006";
    private static final String BILL_TYPE = "BT202205000006";
    private static final String SOURCE_TYPE = "barCode";

    @Override
    public CommonResponse<IPage<CertifregBVO>> queryBPageByHParm(QueryParam param) {
        IPage page = this.bService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertifregBVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @Override
    public CommonResponse<IPage<CertifregFVO>> queryFPageByHParm(QueryParam param) {
        IPage page = this.fService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertifregFVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("pkOrg", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, CertifyregHVO.class);
        return this.exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifyregHVO> vos) {
        for (CertifyregHVO vo : vos) {
            CommonResponse org = this.iOrgApi.getOneById(vo.getPkOrg());
            this.checkRespData(org, true, "\u67e5\u8be2\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", org.getMsg());
            vo.setPkOrgName(((OrgVO)org.getData()).getName());
            CommonResponse applyerorg = this.iOrgApi.getOneById(vo.getApplyerorg());
            this.checkRespData(applyerorg, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", applyerorg.getMsg());
            vo.setApplyerorgName(((OrgVO)applyerorg.getData()).getName());
            CommonResponse vcertcorp = this.iOrgApi.getOneById(vo.getPkVcertcorp());
            this.checkRespData(vcertcorp, true, "\u67e5\u8be2\u6301\u8bc1\u533a\u57df\u5f02\u5e38:", vcertcorp.getMsg());
            vo.setPkVcertcorpName(((OrgVO)vcertcorp.getData()).getName());
            CommonResponse certpsn = this.iEmplApi.getById(vo.getPkCertpsn());
            this.checkRespData(certpsn, true, "\u67e5\u8be2\u6301\u8bc1\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", certpsn.getMsg());
            vo.setPkCertpsnName(((EmployeeVO)certpsn.getData()).getName());
            CommonResponse receiver = this.iEmplApi.getById(vo.getReceiver());
            this.checkRespData(receiver, true, "\u67e5\u8be2\u63a5\u6536\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", receiver.getMsg());
            vo.setReceiverName(((EmployeeVO)receiver.getData()).getName());
            CommonResponse applyer = this.iEmplApi.getById(vo.getApplyer());
            this.checkRespData(applyer, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", applyer.getMsg());
            vo.setApplyerName(((EmployeeVO)applyer.getData()).getName());
            CommonResponse yjdw = this.defdocApi.getDefDocById(vo.getPkYjdw());
            this.checkRespData(yjdw, true, "\u67e5\u8be2\u5f15\u8fdb\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38:", yjdw.getMsg());
            vo.setPkYjdwName(((DefdocDetailVO)yjdw.getData()).getName());
            CommonResponse sbzt = this.defdocApi.getDefDocById(vo.getPkSbzt());
            this.checkRespData(sbzt, true, "\u67e5\u8be2\u793e\u4fdd\u4e3b\u4f53\u4fe1\u606f\u5f02\u5e38:", sbzt.getMsg());
            vo.setPkSbztName(((DefdocDetailVO)sbzt.getData()).getName());
            Optional.ofNullable(this.tservice.selectById(vo.getPkCertiftype())).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));
            Optional.ofNullable(vo.getPkGlzcz()).ifPresent(glzcz -> Optional.ofNullable(this.selectById((Serializable)glzcz)).ifPresent(t -> vo.setPkGlzczName(t.getName())));
            Optional.ofNullable(vo.getPkGlzyz()).ifPresent(glzyz -> Optional.ofNullable(this.selectById((Serializable)glzyz)).ifPresent(t -> vo.setPkGlzyzName(t.getName())));
            String certStatus = Optional.ofNullable(vo.getCertStatus()).orElse("0");
            vo.setCertStatusName(CertStatusEnum.findDesc((String)certStatus));
            Optional.ofNullable(vo.getIsZyzj()).ifPresent(t -> vo.setIsZyzj(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getIsDzzj()).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisusemore()).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyiscrosarea()).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisinstore()).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisreg()).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisuse()).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyispleg()).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyislock()).ifPresent(t -> vo.setApplyislock(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyischanging()).ifPresent(t -> vo.setApplyischanging(YesNoEnum.findDesc((String)t)));
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", vos);
        return beans;
    }

    private void checkRespData(CommonResponse<?> resp, boolean isMustSuc, String title, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? title + errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        if (Objects.isNull(resp.getData())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof List && ListUtil.isEmpty((List)((List)resp.getData()))) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof IPage && ListUtil.isEmpty((List)((IPage)resp.getData()).getRecords())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(Map<String, MultipartFile> fileMap) {
        ArrayList successList = new ArrayList();
        ArrayList failList = new ArrayList();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            MultipartFile file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                return CommonResponse.error((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            List importList = ExcelReader.readExcel((MultipartFile)file);
            Map<String, Object> importResult = this.importTranslate(importList);
            if (((Boolean)importResult.get("errFlag")).booleanValue()) {
                failList.addAll((List)importResult.get("list"));
                continue;
            }
            successList.addAll((List)importResult.get("list"));
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", failList);
        return CommonResponse.success((Object)json);
    }

    private Map<String, Object> importTranslate(List<List<String>> importList) {
        ArrayList<CertifyregHVO> successList = new ArrayList<CertifyregHVO>();
        ArrayList<CertifyregHVO> failList = new ArrayList<CertifyregHVO>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean errFlag = false;
        for (int i = 0; i < importList.size(); ++i) {
            OrgVO orgQuery = new OrgVO();
            StringJoiner errMsg = new StringJoiner(";");
            CertifyregHVO vo = new CertifyregHVO();
            List<String> row = importList.get(i);
            CommonResponse empl = this.iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + row.get(0));
            if (empl.isSuccess()) {
                vo.setPkCertpsn(((EmployeeVO)empl.getData()).getId());
            } else {
                errFlag = true;
                errMsg.add("\u6301\u8bc1\u4eba-" + empl.getMsg());
            }
            vo.setPsnPhone(row.get(1));
            vo.setCardId(row.get(2));
            vo.setPkSbzt(this.sservice.getSubIdByName(row.get(3)).getPkSbzt());
            orgQuery.setName(row.get(4));
            CommonResponse pkVcertcorp = this.iOrgApi.findOneByOrgVO(orgQuery);
            if (pkVcertcorp.isSuccess()) {
                vo.setPkVcertcorp(((OrgVO)pkVcertcorp.getData()).getId());
            } else {
                errFlag = true;
                errMsg.add("\u6301\u8bc1\u533a\u57df-" + pkVcertcorp.getMsg());
            }
            vo.setApplyprofessor(row.get(5));
            Long pkCertiftype = this.tservice.getIdByName(row.get(6));
            if (pkCertiftype == null || pkCertiftype == 0L) {
                errFlag = true;
                errMsg.add("\u8bc1\u7167\u540d\u79f0-\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8bc1\u7167\u7c7b\u522b");
            } else {
                vo.setPkCertiftype(pkCertiftype);
            }
            String certStatusName = Optional.ofNullable(row.get(7)).orElse(CertStatusEnum.INVALID.getDesc());
            vo.setCertStatus(CertStatusEnum.findCode((String)certStatusName));
            vo.setCertifcode(row.get(8));
            orgQuery.setName(row.get(9));
            CommonResponse pkOrg = this.iOrgApi.findOneByOrgVO(orgQuery);
            if (pkOrg.isSuccess()) {
                vo.setPkOrg(((OrgVO)pkOrg.getData()).getId());
            } else {
                errFlag = true;
                errMsg.add("\u7ba1\u7406\u7ec4\u7ec7-" + pkOrg.getMsg());
            }
            SocialInsuranceVO yjdw = this.sservice.getSubIdByName(row.get(11));
            vo.setPkYjdw(yjdw.getPkSbzt());
            vo.setApplyorgtype(yjdw.getSbztType());
            vo.setVgrantcertunit(row.get(12));
            vo.setApplyregdate(row.get(13));
            vo.setReceivedate(row.get(14));
            CommonResponse receiver = this.iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + row.get(15));
            if (receiver.isSuccess()) {
                vo.setReceiver(((EmployeeVO)receiver.getData()).getId());
            } else {
                errFlag = true;
                errMsg.add("\u63a5\u6536\u4eba-" + receiver.getMsg());
            }
            vo.setEffectTime(row.get(16));
            vo.setExpireTime(row.get(17));
            vo.setExpireReason(row.get(18));
            vo.setDgrantcertdate(row.get(19));
            vo.setValidbegindate(row.get(20));
            vo.setValidbegindate(row.get(21));
            if (StringUtils.isNotBlank((CharSequence)row.get(22))) {
                Long pkGlzyzId = this.tservice.getIdByName(row.get(22));
                if (pkGlzyzId != null || pkGlzyzId != 0L) {
                    QueryWrapper pkGlzyzQuery = new QueryWrapper();
                    pkGlzyzQuery.eq((Object)"pk_certpsn", (Object)vo.getPkCertpsn());
                    pkGlzyzQuery.eq((Object)"pk_certiftype", (Object)pkGlzyzId);
                    CertifyregHEntity pkGlzyz = (CertifyregHEntity)((Object)this.getOne((Wrapper)pkGlzyzQuery));
                    if (pkGlzyz != null) {
                        vo.setPkGlzyz(pkGlzyz.getId());
                    } else {
                        errFlag = true;
                        errMsg.add("\u5173\u8054\u6267\u4e1a\u8bc1\u4ef6-\u6ca1\u6709\u5bf9\u5e94\u7684\u6267\u4e1a\u8bc1\u4ef6");
                    }
                } else {
                    errFlag = true;
                    errMsg.add("\u5173\u8054\u6267\u4e1a\u8bc1\u4ef6-\u6ca1\u6709\u5bf9\u5e94\u7684\u8bc1\u7167\u7c7b\u522b");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)row.get(23))) {
                Long pkGlzczId = this.tservice.getIdByName(row.get(23));
                if (pkGlzczId != null || pkGlzczId != 0L) {
                    QueryWrapper pkGlzczQuery = new QueryWrapper();
                    pkGlzczQuery.eq((Object)"pk_certpsn", (Object)vo.getPkCertpsn());
                    pkGlzczQuery.eq((Object)"pk_certiftype", (Object)pkGlzczId);
                    CertifyregHEntity pkGlzcz = (CertifyregHEntity)((Object)this.getOne((Wrapper)pkGlzczQuery));
                    if (pkGlzcz != null) {
                        vo.setPkGlzcz(pkGlzcz.getId());
                    } else {
                        errFlag = true;
                        errMsg.add("\u5173\u8054\u6ce8\u518c\u8bc1-\u6ca1\u6709\u5bf9\u5e94\u7684\u6ce8\u518c\u8bc1");
                    }
                } else {
                    errFlag = true;
                    errMsg.add("\u5173\u8054\u6ce8\u518c\u8bc1-\u6ca1\u6709\u5bf9\u5e94\u7684\u6ce8\u518c\u8bc1");
                }
            }
            vo.setIsZyzj(YesNoEnum.findCode((String)row.get(24)));
            vo.setApplydate(row.get(25));
            vo.setVoperscope(row.get(26));
            CommonResponse applyer = this.iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + row.get(27));
            if (applyer.isSuccess()) {
                vo.setApplyer(((EmployeeVO)applyer.getData()).getId());
            } else {
                errFlag = true;
                errMsg.add("\u53d1\u8d77\u4eba-" + applyer.getMsg());
            }
            orgQuery.setName(row.get(28));
            CommonResponse applyerOrg = this.iOrgApi.findOneByOrgVO(orgQuery);
            if (applyerOrg.isSuccess()) {
                vo.setApplyerorg(((OrgVO)applyerOrg.getData()).getId());
            } else {
                errFlag = true;
                errMsg.add("\u53d1\u8d77\u4eba\u7ec4\u7ec7-" + applyerOrg.getMsg());
            }
            Optional.ofNullable(row.get(29)).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(30)).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(31)).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(32)).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(33)).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(34)).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(35)).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(36)).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findCode((String)t)));
            Optional.ofNullable(row.get(37)).ifPresent(t -> vo.setApplyislock(YesNoEnum.findCode((String)t)));
            DateFormater date = DateFormater.getInstance((Date)DateFormater.getCurrentDate(), (int)8);
            vo.setDbilldate(date.format("yyyy-MM-dd"));
            vo.setPkBilltype(PKBILLTYPE);
            if (errMsg.length() > 0) {
                vo.setErrorMessage("excel\u6587\u6863\u4e2d\u7b2c" + (i + 2) + "\u884c\u6570\u636e\u5f02\u5e38:" + errMsg.toString());
                failList.add(vo);
                continue;
            }
            vo.setBillState(BillStatusEnum.FREE.getId());
            successList.add(vo);
        }
        result.put("errFlag", errFlag);
        if (errFlag) {
            result.put("list", failList);
        } else {
            result.put("list", successList);
        }
        return result;
    }

    @Override
    public CommonResponse<String> scanBillImport(List<AttachmentVO> attachs) {
        HashMap update = new HashMap();
        for (AttachmentVO attachmentVO : attachs) {
            CertifyregHEntity certifyregH;
            ArrayList<Long> updateList = new ArrayList<Long>();
            String[] split = attachmentVO.getFileName().split("-");
            String pkCertpsnCode = split[0];
            CommonResponse empl = this.iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + pkCertpsnCode);
            this.checkRespData(empl, true, "\u67e5\u8be2\u6301\u8bc1\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", empl.getMsg());
            Long emplID = ((EmployeeVO)empl.getData()).getId();
            String pkCertiftypeName = split[1].substring(0, split[1].indexOf("."));
            Long pkCertiftype = this.tservice.getIdByName(pkCertiftypeName);
            if (pkCertiftype != null || pkCertiftype != 0L) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"pk_certpsn", (Object)emplID);
                query.eq((Object)"pk_certiftype", (Object)pkCertiftype);
                certifyregH = (CertifyregHEntity)((Object)this.getOne((Wrapper)query));
                if (certifyregH == null) {
                    throw new BusinessException("\u6839\u636e\u6587\u4ef6\u540d\u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u767b\u8bb0\u5355");
                }
            } else {
                throw new BusinessException("\u6839\u636e\u6587\u4ef6\u540d\u67e5\u627e\u4e0d\u5230\u8bc1\u7167\u7c7b\u522b");
            }
            attachmentVO.setSourceId(certifyregH.getId());
            CommonResponse attachResp = this.iAttachmentApi.queryListBySourceId(attachmentVO.getSourceId(), attachmentVO.getBillType(), attachmentVO.getSourceType(), null);
            this.checkRespData(attachResp, true, "\u67e5\u8be2\u9644\u4ef6\u63a5\u53e3\u5f02\u5e38:", attachResp.getMsg());
            if (!attachResp.isSuccess() || !ListUtil.isNotEmpty((List)((List)attachResp.getData()))) continue;
            for (AttachmentVO datum : (List)attachResp.getData()) {
                updateList.add(datum.getId());
            }
            update.put(attachmentVO.getSourceId(), updateList);
        }
        for (Map.Entry entry : update.entrySet()) {
            CommonResponse updateResp = this.iAttachmentApi.updateAttachRef((Long)entry.getKey(), (List)entry.getValue());
            this.checkRespData(updateResp, true, "\u66f4\u65b0\u9644\u4ef6\u63a5\u53e3\u5f02\u5e38:", updateResp.getMsg());
        }
        CommonResponse response = this.iAttachmentApi.insertBatch(attachs);
        this.checkRespData(response, true, "\u626b\u63cf\u5355\u4fdd\u5b58\u5931\u8d25:", response.getMsg());
        return CommonResponse.success((String)"\u4e0a\u4f20\u626b\u63cf\u4ef6\u6210\u529f!");
    }

    @Override
    public CommonResponse<String> GenBarCode(Long id) {
        UserContext userContextCache = this.sessionManager.getUserContext();
        String userCode = this.sessionManager.getUserContext().getUserCode();
        Long tenantid = this.sessionManager.getUserContext().getTenantid();
        CertifyregHEntity entity = (CertifyregHEntity)((Object)this.selectById(id));
        if (entity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230id\uff1a" + id + "\u7684\u767b\u8bb0\u5355\u6570\u636e");
        }
        CommonResponse attachs = this.iAttachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        if (attachs.isSuccess() && ListUtil.isNotEmpty((List)((List)attachs.getData()))) {
            StringJoiner sj = new StringJoiner(",");
            ((List)attachs.getData()).forEach(item -> sj.add(String.valueOf(item.getId())));
            this.iAttachmentApi.delete(sj.toString());
        }
        BufferedImage image = BarCodeUtils.insertWords((BufferedImage)BarCodeUtils.getBarCode((String)entity.getZjCode()), (String)entity.getZjCode());
        AttachmentRequestVO attach = new AttachmentRequestVO();
        attach.setBillType(BILL_TYPE);
        attach.setSourceId(String.valueOf(entity.getId()));
        attach.setSourceType(SOURCE_TYPE);
        attach.setCreateTime(DateFormater.getCurrentDate());
        attach.setCreateUserCode(userCode);
        attach.setTenantId(tenantid);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", stream);
            byte[] bytes = stream.toByteArray();
            BASE64Encoder encoder = new BASE64Encoder();
            String base64 = "data:image/png;base64," + encoder.encodeBuffer(bytes);
            ArrayList<String> files = new ArrayList<String>();
            files.add(base64);
            attach.setFileList(files);
        }
        catch (IOException e) {
            throw new BusinessException("\u6761\u5f62\u7801\u56fe\u7247\u8f6c\u6210base64\u5f02\u5e38");
        }
        CommonResponse response = this.iAttachmentApi.uploadForBase64(attach);
        this.checkRespData(response, true, "\u6761\u5f62\u7801\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25:", response.getMsg());
        return CommonResponse.success((String)"\u6210\u529f");
    }

    @Override
    public IPage<CertifyregHVO> refCertifyregHData(Integer pageNumber, Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map<String, List<Long>> userAuths = this.getUserAuths();
        for (String key : userAuths.keySet()) {
            param.getParams().put(key, new Parameter("in", userAuths.get(key)));
        }
        if (StringUtils.isNotEmpty((CharSequence)searchObject)) {
            param = this.dealRefObject(searchObject, param);
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            param = this.addParamByCon(condition, param);
        }
        IPage page = this.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertifyregHVO.class));
        return pageData;
    }

    private QueryParam dealRefObject(String searchObject, QueryParam param) {
        JSONObject object = JSONObject.parseObject((String)searchObject);
        Iterator iterator = object.keySet().iterator();
        block8: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "pkCertpsn.name": {
                    object.remove((Object)"pkCertpsn.name");
                    continue block8;
                }
                case "pkCertiftype.name": {
                    Long tid = this.tservice.getIdByName((String)object.get((Object)key));
                    param.getParams().put("pkCertiftype", new Parameter("eq", (Object)tid));
                    object.remove((Object)"pkCertiftype.name");
                    continue block8;
                }
            }
            param.getParams().put(key, new Parameter("eq", object.get((Object)key)));
        }
        return param;
    }

    private QueryParam addParamByCon(String condition, QueryParam param) {
        JSONObject _con = JSONObject.parseObject((String)condition);
        Iterator iterator = _con.keySet().iterator();
        block10: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "specialReqId": {
                    long reqId = Long.parseLong(_con.get((Object)key).toString());
                    QueryParam querySreq = new QueryParam();
                    querySreq.setPageIndex(1);
                    querySreq.setPageSize(-1);
                    querySreq.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                    querySreq.getParams().put("pkSpecialreq", new Parameter("eq", (Object)reqId));
                    CommonResponse<IPage<CertifySpecialReqBVO>> page = this.sreqService.queryBPageByHParm(querySreq);
                    this.checkRespData(page, true, "\u83b7\u53d6\u7279\u6b8a\u8bf7\u793a\u8868\u5934\u5931\u8d25:", null);
                    List blist = ((IPage)page.getData()).getRecords().stream().map(CertifySpecialReqBVO::getPkCertifreg).collect(Collectors.toList());
                    ComplexParam complexParam = new ComplexParam();
                    complexParam.setLogic("or");
                    complexParam.getParams().put("id", new Parameter("in", blist));
                    param.getComplexParams().add(complexParam);
                    continue block10;
                }
                case "specialtype": {
                    List certifTypes;
                    List ids;
                    ArrayList attrIds = new ArrayList();
                    String _var = (String)_con.get((Object)key);
                    CommonResponse defdoc = this.defdocApi.getDefDocByDefCode(TYPEATTRIBUTE_CODE);
                    this.checkRespData(defdoc, true, "\u83b7\u53d6\u793e\u4fdd\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25:", defdoc.getMsg());
                    ((List)defdoc.getData()).forEach(attr -> {
                        if ("0".equals(_var) && attr.getName().contains("\u6ce8\u518c")) {
                            attrIds.add(attr.getId());
                        }
                        if ("1".equals(_var) && attr.getName().equals("B\u8bc1")) {
                            attrIds.add(attr.getId());
                        }
                    });
                    QueryWrapper queryWrapper = new QueryWrapper();
                    if (attrIds.size() == 1) {
                        queryWrapper.eq((Object)"specialtype", attrIds.get(0));
                    } else if (attrIds.size() > 1) {
                        queryWrapper.in((Object)"specialtype", attrIds);
                    }
                    if (!ListUtil.isNotEmpty(ids = (certifTypes = this.tservice.getBaseMapper().selectList((Wrapper)queryWrapper)).stream().map(BaseEntity::getId).collect(Collectors.toList()))) continue block10;
                    param.getParams().put("pkCertiftype", new Parameter("in", ids));
                    continue block10;
                }
                case "pkOrg": {
                    long orgId = Long.parseLong(_con.get((Object)key).toString());
                    CommonResponse childResp = this.iOrgApi.findChildrenByParentId(Long.valueOf(orgId));
                    this.checkRespData(childResp, true, "\u67e5\u627e\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", null);
                    List childs = (List)childResp.getData();
                    List pkOrgs = childs.stream().map(BaseVO::getId).collect(Collectors.toList());
                    param.getParams().put("pkOrg", new Parameter("in", pkOrgs));
                    continue block10;
                }
            }
            param.getParams().put(key, new Parameter("eq", _con.get((Object)key)));
        }
        return param;
    }

    private Map<String, List<Long>> getUserAuths() {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            List ids = Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            CommonResponse childsResp = this.iOrgApi.findChildrenByParentIds(ids);
            this.checkRespData(childsResp, true, "\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25:", null);
            orgVOList = (List)childsResp.getData();
        } else {
            CommonResponse childsResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            this.checkRespData(childsResp, true, "\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25:", null);
            orgVOList = (List)childsResp.getData();
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            result.put("pkOrg", commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            result.put("pkDept", departmentIds);
        }
        return result;
    }
}

