/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.SocialInsuranceEntity;
import com.ejianc.certify.mapper.SocialInsuranceMapper;
import com.ejianc.certify.service.ISocialInsuranceService;
import com.ejianc.certify.vo.SocialInsuranceVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="socialInsuranceService")
public class SocialInsuranceServiceImpl
extends BaseServiceImpl<SocialInsuranceMapper, SocialInsuranceEntity>
implements ISocialInsuranceService {
    @Autowired
    private IDefdocApi iDefdocApi;
    private static final String SOCIAL_SUBJECT_DEF_CODE = "credentials-social_security_subjects";
    @Autowired
    private SocialInsuranceMapper socialInsuranceMapper;

    @Override
    public SocialInsuranceVO getSocialInsuranceVoByCardId(String cardId, String sbMonth) {
        return ((SocialInsuranceMapper)this.getBaseMapper()).getSocialInsuranceVoByCardId(cardId, sbMonth);
    }

    @Override
    public CommonResponse<SocialInsuranceVO> getSubInfoByEmplID(Long pkPsnid) {
        SocialInsuranceVO result = new SocialInsuranceVO();
        List<SocialInsuranceEntity> infos = this.socialInsuranceMapper.getSubInfoByEmplID(pkPsnid);
        if (infos.size() > 0) {
            result.setPkSbzt(infos.get(0).getPkSbzt());
            result.setLastSbMonth(infos.get(0).getSbMonth());
            result.setTotalSbMonth(infos.size());
            return CommonResponse.success((Object)((Object)result));
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u793e\u4fdd\u7f34\u7eb3\u8bb0\u5f55");
    }

    @Override
    public CommonResponse<IPage<DefdocDetailVO>> refSocialSubjectData(String condition, String searchObject, String searchText) {
        CommonResponse defCode = this.iDefdocApi.getDefDocByDefCode(SOCIAL_SUBJECT_DEF_CODE);
        if (defCode.isSuccess()) {
            Page pageData = new Page(1L, (long)((List)defCode.getData()).size(), (long)((List)defCode.getData()).size());
            pageData.setRecords((List)defCode.getData());
            return CommonResponse.success((Object)pageData);
        }
        return CommonResponse.error((String)defCode.getMsg());
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public SocialInsuranceVO getSubIdByName(String name) {
        CommonResponse defdoc = this.iDefdocApi.getDefdocByDefCode(SOCIAL_SUBJECT_DEF_CODE);
        this.getRespData(defdoc, true, "\u83b7\u53d6\u793e\u4fdd\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25:" + defdoc.getMsg());
        CommonResponse subInfo = this.iDefdocApi.getDefDocByName(((DefdocVO)defdoc.getData()).getId(), name);
        this.getRespData(subInfo, true, "\u83b7\u53d6\u793e\u4fdd\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25:" + defdoc.getMsg());
        SocialInsuranceVO sbzt = new SocialInsuranceVO();
        sbzt.setPkSbzt(((DefdocDetailVO)subInfo.getData()).getId());
        sbzt.setSbztType(((DefdocDetailVO)subInfo.getData()).getDescription());
        return sbzt;
    }
}

