package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifChangeFEntity;
import com.ejianc.certify.bean.CertifregFEntity;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.ChangTypeEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.service.ICertifChangeFService;
import com.ejianc.certify.service.ICertifTypeService;
import com.ejianc.certify.service.ICertifyregHService;
import com.ejianc.certify.vo.CertifChangeFVO;
import com.ejianc.certify.vo.CertifregFVO;
import com.ejianc.certify.vo.CertifyChangeHVO;
import com.ejianc.certify.vo.CertifyregHVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.CertifyChangeHMapper;
import com.ejianc.certify.bean.CertifyChangeHEntity;
import com.ejianc.certify.service.ICertifyChangeHService;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 证照变更-表头
 * 
 * @author generator
 * 
 */
@Service("certifyChangeHService")
public class CertifyChangeHServiceImpl extends BaseServiceImpl<CertifyChangeHMapper, CertifyChangeHEntity> implements ICertifyChangeHService{
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Resource
    private IDefdocApi defdocApi;
    @Resource
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private ICertifTypeService tservice;
    @Autowired
    private ICertifyregHService hService;
    @Autowired
    private ICertifChangeFService changeFService;



    private void checkRespData(CommonResponse<?> resp, boolean isMustSuc,String title, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        if (Objects.isNull(resp.getData())){
            throw new BusinessException(title + "查询不到数据!");
        }
        if (resp.getData() instanceof List && ListUtil.isEmpty((List)resp.getData())){
            throw new BusinessException(title + "查询不到数据!");
        }
        if (resp.getData() instanceof IPage && ListUtil.isEmpty(((IPage)resp.getData()).getRecords())){
            throw new BusinessException(title + "查询不到数据!");
        }
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("pkOrg",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertifyChangeHEntity> list = queryList(param);
        //todo:字段翻译等等
        List<CertifyChangeHVO> vos = BeanMapper.mapList(list, CertifyChangeHVO.class);
        return exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifyChangeHVO> vos) {
        for (CertifyChangeHVO vo : vos) {
            CommonResponse<OrgVO> org = iOrgApi.getOneById(vo.getPkOrg());
            checkRespData(org, true, "查询管理组织信息异常:" , org.getMsg());
            vo.setPkOrgName(org.getData().getName());

            CommonResponse<OrgVO> applyerorg = iOrgApi.getOneById(vo.getApplyerorg());
            checkRespData(applyerorg, true, "查询发起人组织信息异常:" , applyerorg.getMsg());
            vo.setApplyerorgName(applyerorg.getData().getName());

            CommonResponse<OrgVO> vcertcorp = iOrgApi.getOneById(vo.getPkVcertcorp());
            checkRespData(vcertcorp, true, "查询持证区域异常:" , vcertcorp.getMsg());
            vo.setPkVcertcorpName(vcertcorp.getData().getName());

            CommonResponse<EmployeeVO> certpsn = iEmplApi.getById(vo.getPkCertpsn());
            checkRespData(certpsn, true, "查询持证人员信息异常:" , certpsn.getMsg());
            vo.setPkCertpsnName(certpsn.getData().getName());

            CommonResponse<EmployeeVO> receiver = iEmplApi.getById(vo.getReceiver());
            checkRespData(receiver, true, "查询接收人员信息异常:" , receiver.getMsg());
            vo.setReceiverName(receiver.getData().getName());

            CommonResponse<EmployeeVO> applyer = iEmplApi.getById(vo.getApplyer());
            checkRespData(applyer, true, "查询发起人员信息异常:" , applyer.getMsg());
            vo.setApplyerName(applyer.getData().getName());

            CommonResponse<DefdocDetailVO> yjdw = defdocApi.getDefDocById(vo.getPkYjdw());
            checkRespData(yjdw, true, "查询引进单位信息异常:" , yjdw.getMsg());
            vo.setPkYjdwName(yjdw.getData().getName());

            CommonResponse<DefdocDetailVO> sbzt = defdocApi.getDefDocById(vo.getPkSbzt());
            checkRespData(sbzt, true, "查询社保主体信息异常:" , sbzt.getMsg());
            vo.setPkSbztName(sbzt.getData().getName());

            Optional.ofNullable(tservice.selectById(vo.getPkCertiftype())).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));
            Optional.ofNullable(vo.getPkGlzcz()).ifPresent(glzcz -> {
                Optional.ofNullable(hService.selectById(glzcz)).ifPresent(t -> vo.setPkGlzczName(t.getName()));
            });
            Optional.ofNullable(vo.getPkGlzyz()).ifPresent(glzyz -> {
                Optional.ofNullable(hService.selectById(glzyz)).ifPresent(t -> vo.setPkGlzyzName(t.getName()));
            });

            String certStatus = Optional.ofNullable(vo.getCertStatus()).orElse("0");
            vo.setCertStatusName(CertStatusEnum.findDesc(certStatus));
            Optional.ofNullable(vo.getIsZyzj()).ifPresent(t -> vo.setIsZyzj(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getIsDzzj()).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisusemore()).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyiscrosarea()).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisinstore()).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisreg()).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisuse()).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyispleg()).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyislock()).ifPresent(t -> vo.setApplyislock(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyischanging()).ifPresent(t -> vo.setApplyischanging(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getChangeType()).ifPresent(t -> {vo.setChangeType(ChangTypeEnum.findDesc(t));});
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        return beans;
    }


    /**
     * @param param
     * @description 根据证照变更单参数分页查询基本补贴调整额
     * @author yxm
     * @date 2022/5/25
     */
    @Override
    public CommonResponse<IPage<CertifChangeFVO>> queryFPageByHParm(QueryParam param) {
        IPage<CertifChangeFEntity> page = changeFService.queryPage(param, false);
        IPage<CertifChangeFVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifChangeFVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }
}
