package com.ejianc.certify.service.impl;

import com.ejianc.certify.bean.CorpApplyHEntity;
import com.ejianc.certify.bean.CorpCertifHEntity;
import com.ejianc.certify.convert.IApplyToPzConvert;
import com.ejianc.certify.service.ICorpApplyHService;
import com.ejianc.certify.service.ICorpCertifHService;
import com.ejianc.certify.vo.CorpApplyHVO;
import com.ejianc.certify.vo.CorpCertifBVO;
import com.ejianc.certify.vo.CorpCertifHVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service("corpApplyH") 
public class CorpApplyHBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ICorpApplyHService applyHService;
	@Autowired
	private ICorpCertifHService corpService;
	@Autowired
	private IApplyToPzConvert applyToPzConvert;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if(state == 3){
			//1、生成公司借证配证单
			CorpApplyHEntity entity = applyHService.selectById(billId);
			CorpApplyHVO applyHVO = BeanMapper.map(entity, CorpApplyHVO.class);

			CorpCertifHVO saveOrUpdateVO = new CorpCertifHVO();
			//其实下面表头的映射也可以使用MapStruct，先不改了......
			saveOrUpdateVO.setVbusitype(applyHVO.getVbusitype());
			DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
			saveOrUpdateVO.setDbilldate(dtf.format(LocalDateTime.now()));
			saveOrUpdateVO.setVmemo(applyHVO.getVmemo());
			saveOrUpdateVO.setPkCorpcertifapply(billId);
			saveOrUpdateVO.setFqrOrg(applyHVO.getPkOrg());
			saveOrUpdateVO.setFqrDept(applyHVO.getPkDept());
			saveOrUpdateVO.setPkFqr(applyHVO.getPkFqr());
			saveOrUpdateVO.setApplyerTel(applyHVO.getApplyerTel());
			saveOrUpdateVO.setApplydate(applyHVO.getApplydate());
			saveOrUpdateVO.setApplyreason(applyHVO.getApplyreason());
			saveOrUpdateVO.setPkProject(applyHVO.getPkProject());
			saveOrUpdateVO.setPkContract(applyHVO.getPkContract());
			saveOrUpdateVO.setPkPmproject(applyHVO.getPkPmproject());
			saveOrUpdateVO.setPkPmprojectJlb(applyHVO.getPkPmprojectJlb());
			saveOrUpdateVO.setProjectFinishTime(applyHVO.getProjectFinishTime());

			List<CorpCertifBVO> certifBVOList = applyToPzConvert.applyBodyToPO(applyHVO.getCorpApplyBList());
			saveOrUpdateVO.setCorpCertifBVOList(certifBVOList);

			corpService.scbill(saveOrUpdateVO);
			//2、发送配证单待办消息给证件配置岗人员

		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//判断是否存在下游单据，存在则不能弃审
		check(billId);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 判断是否存在下游单据，存在则不能弃审
	 * @param billId
	 */
	public void check(Long billId) {
		QueryParam param = new QueryParam();
		param.getParams().put("pkCorpcertifapply", new Parameter(QueryParam.EQ, billId));
		List<CorpCertifHEntity> corpCertifHEntities = corpService.queryList(param);

		if (!CollectionUtils.isEmpty(corpCertifHEntities)) {
			CommonResponse.error("存在下游单据，不能弃审！");
		}
	}
}
