package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CorpCertifBEntity;
import com.ejianc.certify.mapper.CorpCertifBMapper;
import com.ejianc.certify.service.ICorpCertifBService;
import com.ejianc.certify.vo.CorpCertifBVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 证件借用配件-表体
 * 
 * @author generator
 * 
 */
@Service("corpCertifBService")
public class CorpCertifBServiceImpl extends BaseServiceImpl<CorpCertifBMapper, CorpCertifBEntity> implements ICorpCertifBService{

    @Override
    public CommonResponse<IPage<CorpCertifBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CorpCertifBEntity> page = this.queryPage(param,false);
        IPage<CorpCertifBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CorpCertifBVO.class));

        return CommonResponse.success("查询明细数据成功！",pageData);
    }
}
