package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.vo.CorpCertifFVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.certify.mapper.CorpCertifFMapper;
import com.ejianc.certify.bean.CorpCertifFEntity;
import com.ejianc.certify.service.ICorpCertifFService;

/**
 * 证件借用配件-配证详情
 * 
 * @author generator
 * 
 */
@Service("corpCertifFService")
public class CorpCertifFServiceImpl extends BaseServiceImpl<CorpCertifFMapper, CorpCertifFEntity> implements ICorpCertifFService{
    @Autowired
    private ICorpCertifFService bService;

    @Override
    public CommonResponse<IPage<CorpCertifFVO>> queryBPageByHParm(QueryParam param) {
        IPage<CorpCertifFEntity> page = bService.queryPage(param,false);
        IPage<CorpCertifFVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CorpCertifFVO.class));

        return CommonResponse.success("查询明细数据成功！",pageData);
    }
}
