package com.ejianc.certify.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 证件类别
 *
 * @author generator
 */
public class CertifTypeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long pkParent; // 父节点pk
    private String pkGroup; // 集团
    private Long pkOrg; // 组织
    private String code; // 编码
    private String name; // 名称
    private String innercode; // 内部编码
    private Integer enablestate; // 0-未启用 1-已启用 2-已停用
    private Long typeattribute; // 证照类别属性
    private Long specialtype; // 特殊证照类别
    private String jfrule; // 持证补贴计费规则（0-不计费 1-独自生效 2-关联证件生效 ）
    private Long relateCertiftype; // 关联证照类别
    private Integer rowNum; // 排序
    private String hasEffectiveDate; // 是否存在证件有效期预警 0-是 1-否
    private Integer warnTime; // 预警提醒时长（月）
    private Integer advanceTime; // 失效提前预警时间（月）
    private String disposable; // 是否一次性奖励, 0-是  1-否
    private BigDecimal disposAmt; // 一次性奖励额
    private String yzdybtAmt; // 一证多用补贴额
    private BigDecimal nbasicbenefit; // 基本补贴额
    private BigDecimal nusebenefit; // 使用补贴额
    private BigDecimal ncheckbenefit; // 迎检出场补贴额
    private BigDecimal nyzbenefit; // 造价工程师用印补贴额
    private String gwrule; // 岗位补贴计算规则
    private String ngwbenefit; // 岗位补贴额
    private String vmemo; // 备注
    private String vdef1; //
    private String vdef10; //
    private String vdef2; //
    private String vdef3; //
    private String vdef5; //
    private String vdef4; //
    private String vdef6; //
    private String vdef7; //
    private String vdef8; //
    private String vdef9; //
    private Date ts; // 时间戳

    private String orgName;
    private String typeattributeName;
    private String specialtypeName;
    private String relateCertiftypeName;
    private String stateName;
    private List<CertifTypeVO> children;

    public List<CertifTypeVO> getChildren() {
        return children;
    }

    public void setChildren(List<CertifTypeVO> children) {
        this.children = children;
    }

    public void setRelateCertiftypeName(String relateCertiftypeName) {
        this.relateCertiftypeName = relateCertiftypeName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getTypeattributeName() {
        return typeattributeName;
    }

    public void setTypeattributeName(String typeattributeName) {
        this.typeattributeName = typeattributeName;
    }

    public String getSpecialtypeName() {
        return specialtypeName;
    }

    public void setSpecialtypeName(String specialtypeName) {
        this.specialtypeName = specialtypeName;
    }


    public String getRelateCertiftypeName() {
        return relateCertiftypeName;
    }


    public String getStateName() {
        return stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    @ReferSerialTransfer(referCode="certifType")
    public Long getPkParent() {
        return pkParent;
    }
    @ReferDeserialTransfer
    public void setPkParent(Long pkParent) {
        this.pkParent = pkParent;
    }

    public String getPkGroup() {
        return pkGroup;
    }

    public void setPkGroup(String pkGroup) {
        this.pkGroup = pkGroup;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getPkOrg() {
        return pkOrg;
    }

    @ReferDeserialTransfer
    public void setPkOrg(Long pkOrg) {
        this.pkOrg = pkOrg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInnercode() {
        return innercode;
    }

    public void setInnercode(String innercode) {
        this.innercode = innercode;
    }

    public Integer getEnablestate() {
        return enablestate;
    }

    public void setEnablestate(Integer enablestate) {
        this.enablestate = enablestate;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getTypeattribute() {
        return typeattribute;
    }

    @ReferDeserialTransfer
    public void setTypeattribute(Long typeattribute) {
        this.typeattribute = typeattribute;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getSpecialtype() {
        return specialtype;
    }

    @ReferDeserialTransfer
    public void setSpecialtype(Long specialtype) {
        this.specialtype = specialtype;
    }

    public String getJfrule() {
        return jfrule;
    }

    public void setJfrule(String jfrule) {
        this.jfrule = jfrule;
    }

    @ReferSerialTransfer(referCode="certifType")
    public Long getRelateCertiftype() {
        return relateCertiftype;
    }

    @ReferDeserialTransfer
    public void setRelateCertiftype(Long relateCertiftype) {
        this.relateCertiftype = relateCertiftype;
    }

    public Integer getRowNum() {
        return rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public String getHasEffectiveDate() {
        return hasEffectiveDate;
    }

    public void setHasEffectiveDate(String hasEffectiveDate) {
        this.hasEffectiveDate = hasEffectiveDate;
    }

    public Integer getWarnTime() {
        return warnTime;
    }

    public void setWarnTime(Integer warnTime) {
        this.warnTime = warnTime;
    }

    public Integer getAdvanceTime() {
        return advanceTime;
    }

    public void setAdvanceTime(Integer advanceTime) {
        this.advanceTime = advanceTime;
    }

    public String getDisposable() {
        return disposable;
    }

    public void setDisposable(String disposable) {
        this.disposable = disposable;
    }

    public BigDecimal getDisposAmt() {
        return disposAmt;
    }

    public void setDisposAmt(BigDecimal disposAmt) {
        this.disposAmt = disposAmt;
    }

    public String getYzdybtAmt() {
        return yzdybtAmt;
    }

    public void setYzdybtAmt(String yzdybtAmt) {
        this.yzdybtAmt = yzdybtAmt;
    }

    public BigDecimal getNbasicbenefit() {
        return nbasicbenefit;
    }

    public void setNbasicbenefit(BigDecimal nbasicbenefit) {
        this.nbasicbenefit = nbasicbenefit;
    }

    public BigDecimal getNusebenefit() {
        return nusebenefit;
    }

    public void setNusebenefit(BigDecimal nusebenefit) {
        this.nusebenefit = nusebenefit;
    }

    public BigDecimal getNcheckbenefit() {
        return ncheckbenefit;
    }

    public void setNcheckbenefit(BigDecimal ncheckbenefit) {
        this.ncheckbenefit = ncheckbenefit;
    }

    public BigDecimal getNyzbenefit() {
        return nyzbenefit;
    }

    public void setNyzbenefit(BigDecimal nyzbenefit) {
        this.nyzbenefit = nyzbenefit;
    }

    public String getGwrule() {
        return gwrule;
    }

    public void setGwrule(String gwrule) {
        this.gwrule = gwrule;
    }

    public String getNgwbenefit() {
        return ngwbenefit;
    }

    public void setNgwbenefit(String ngwbenefit) {
        this.ngwbenefit = ngwbenefit;
    }

    public String getVmemo() {
        return vmemo;
    }

    public void setVmemo(String vmemo) {
        this.vmemo = vmemo;
    }

    public String getVdef1() {
        return vdef1;
    }

    public void setVdef1(String vdef1) {
        this.vdef1 = vdef1;
    }

    public String getVdef10() {
        return vdef10;
    }

    public void setVdef10(String vdef10) {
        this.vdef10 = vdef10;
    }

    public String getVdef2() {
        return vdef2;
    }

    public void setVdef2(String vdef2) {
        this.vdef2 = vdef2;
    }

    public String getVdef3() {
        return vdef3;
    }

    public void setVdef3(String vdef3) {
        this.vdef3 = vdef3;
    }

    public String getVdef5() {
        return vdef5;
    }

    public void setVdef5(String vdef5) {
        this.vdef5 = vdef5;
    }

    public String getVdef4() {
        return vdef4;
    }

    public void setVdef4(String vdef4) {
        this.vdef4 = vdef4;
    }

    public String getVdef6() {
        return vdef6;
    }

    public void setVdef6(String vdef6) {
        this.vdef6 = vdef6;
    }

    public String getVdef7() {
        return vdef7;
    }

    public void setVdef7(String vdef7) {
        this.vdef7 = vdef7;
    }

    public String getVdef8() {
        return vdef8;
    }

    public void setVdef8(String vdef8) {
        this.vdef8 = vdef8;
    }

    public String getVdef9() {
        return vdef9;
    }

    public void setVdef9(String vdef9) {
        this.vdef9 = vdef9;
    }

    public Date getTs() {
        return ts;
    }

    public void setTs(Date ts) {
        this.ts = ts;
    }

}
