package com.ejianc.certify.service.impl;

import com.ejianc.certify.bean.AccountBaseEntity;
import com.ejianc.certify.bean.CertifyregHEntity;
import com.ejianc.certify.mapper.AccountBaseMapper;
import com.ejianc.certify.service.IAccountBaseService;
import com.ejianc.certify.service.ICertifyregHService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 基本补贴表
 * 
 * @author generator
 * 
 */
@Service("accountBaseService")
public class AccountBaseServiceImpl extends BaseServiceImpl<AccountBaseMapper, AccountBaseEntity> implements IAccountBaseService{
    @Autowired
    private ICertifyregHService certifyregHService;
    @Autowired
    private IEmployeeApi iEmplApi;

    /**
     * @param id 证件登记id
     * @return
     */
    @Override
    public AccountBaseEntity selectCertifyInfo(String id) {
        CertifyregHEntity certifyregH = certifyregHService.getById(id);
        CommonResponse<EmployeeVO> resp = iEmplApi.getById(certifyregH.getPkCertpsn());
        if(!resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(resp.getMsg()) ? resp.getMsg() : "调用Rpc服务失败");
        }
        AccountBaseEntity accountBase = new AccountBaseEntity();
        accountBase.setPsncode(resp.getData().getCode());

        return accountBase;
    }
}
