package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifyExpireBEntity;
import com.ejianc.certify.mapper.CertifyExpireBMapper;
import com.ejianc.certify.service.ICertifyExpireBService;
import com.ejianc.certify.vo.CertifyExpireBVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 证件失效-表体
 * 
 * @author generator
 * 
 */
@Service("certifyExpireBService")
public class CertifyExpireBServiceImpl extends BaseServiceImpl<CertifyExpireBMapper, CertifyExpireBEntity> implements ICertifyExpireBService{
    @Override
    public CommonResponse<IPage<CertifyExpireBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CertifyExpireBEntity> page = this.queryPage(param,false);
        IPage<CertifyExpireBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifyExpireBVO.class));

        return CommonResponse.success("查询明细数据成功！",pageData);
    }
}
