package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifyReplaceBEntity;
import com.ejianc.certify.mapper.CertifyReplaceBMapper;
import com.ejianc.certify.service.ICertifyReplaceBService;
import com.ejianc.certify.vo.CertifyReplaceBVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 证照替换申请-表体
 * 
 * @author generator
 * 
 */
@Service("certifyReplaceBService")
public class CertifyReplaceBServiceImpl extends BaseServiceImpl<CertifyReplaceBMapper, CertifyReplaceBEntity> implements ICertifyReplaceBService{

    @Override
    public CommonResponse<IPage<CertifyReplaceBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CertifyReplaceBEntity> page = this.queryPage(param,false);
        IPage<CertifyReplaceBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifyReplaceBVO.class));

        return CommonResponse.success("查询明细数据成功！",pageData);
    }
}
