package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifChangeFEntity;
import com.ejianc.certify.bean.CertifyChangeHEntity;
import com.ejianc.certify.bean.CertifySpecialReqBEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.service.ICertifySpecialReqBService;
import com.ejianc.certify.utils.RpcUtil;
import com.ejianc.certify.vo.CertifChangeFVO;
import com.ejianc.certify.vo.CertifyChangeHVO;
import com.ejianc.certify.vo.CertifySpecialReqBVO;
import com.ejianc.certify.vo.CertifySpecialReqVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.CertifySpecialReqMapper;
import com.ejianc.certify.bean.CertifySpecialReqEntity;
import com.ejianc.certify.service.ICertifySpecialReqService;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 特殊请示-表头
 * 
 * @author generator
 * 
 */
@Service("certifySpecialReqService")
public class CertifySpecialReqServiceImpl extends BaseServiceImpl<CertifySpecialReqMapper, CertifySpecialReqEntity> implements ICertifySpecialReqService{
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;

    @Autowired
    private ICertifySpecialReqBService bservice;


    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("pkOrg",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertifySpecialReqEntity> list = queryList(param);
        //todo:字段翻译等等
        List<CertifySpecialReqVO> vos = BeanMapper.mapList(list, CertifySpecialReqVO.class);
        return exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifySpecialReqVO> vos) {
        for (CertifySpecialReqVO vo : vos) {
            CommonResponse<OrgVO> org = iOrgApi.getOneById(vo.getPkOrg());
            RpcUtil.checkRespData(org, true, "查询管理组织信息异常:" , org.getMsg());
            vo.setPkOrgName(org.getData().getName());

            CommonResponse<EmployeeVO> applyer = iEmplApi.getById(vo.getApplyer());
            RpcUtil.checkRespData(applyer, true, "查询发起人员信息异常:" , applyer.getMsg());
            vo.setApplyerName(applyer.getData().getName());

            CommonResponse<OrgVO> applyerorg = iOrgApi.getOneById(vo.getApplyerorg());
            RpcUtil.checkRespData(applyerorg, true, "查询发起人组织信息异常:" , applyerorg.getMsg());
            vo.setApplyerorgName(applyerorg.getData().getName());

            Optional.ofNullable(vo.getVbusitype()).ifPresent(type -> {
                switch (vo.getVbusitype()){
                    case "1":
                        vo.setVbusitype("跨区借用");
                        break;
                    case "2":
                        vo.setVbusitype("一证多用");
                        break;
                    default:
                        break;
                }
            });


            Optional.ofNullable(vo.getBillState()).ifPresent(t -> vo.setBillStateName(BillStatusEnum.getDesc(t)));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        return beans;
    }

    /**
     * @param param
     * @description 根据证照变更单参数分页查询基本补贴调整额
     * @author yxm
     * @date 2022/5/25
     */
    @Override
    public CommonResponse<IPage<CertifySpecialReqBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CertifySpecialReqBEntity> page = bservice.queryPage(param, false);
        IPage<CertifySpecialReqBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifySpecialReqBVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }
}
